/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.prog.CommentStatement;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamKind;
import hu.ppke.itk.plang.prog.StreamState;
import hu.ppke.itk.plang.prog.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public final class State
implements Cloneable {
    private Statement current;
    private long steps;
    private Map<String, Object> vars;
    private Environment env;
    private Map<String, StreamData> streams;
    private Map<String, StreamState> streamStates;
    private Map<Integer, Double> randomState = null;
    private Map<Integer, List<State>> subStateLists = null;
    private String error;

    private State(Environment env, Map<String, Object> vars, Map<String, StreamData> streams, Map<String, StreamState> streamStates, long steps) {
        this.env = env;
        this.vars = vars;
        this.streams = streams;
        this.streamStates = streamStates;
        this.steps = steps;
    }

    State(Environment env, long maxSteps) {
        this.env = env;
        this.steps = maxSteps;
        this.vars = env.createVariables();
        this.streams = new TreeMap<String, StreamData>();
        this.streamStates = new TreeMap<String, StreamState>();
        StreamKind[] streamKindArray = StreamKind.values();
        int n = streamKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            StreamKind kind = streamKindArray[n2];
            for (String name : env.getStreams(kind)) {
                this.streams.put(name, new StreamData(kind));
                this.streamStates.put(name, new StreamState());
            }
            ++n2;
        }
    }

    State(Environment env, State parent) {
        this.env = env;
        this.steps = parent.steps;
        this.vars = env.createVariables();
        this.streams = parent.streams;
        this.streamStates = new HashMap<String, StreamState>(parent.streamStates.size());
        for (String stream : parent.streamStates.keySet()) {
            this.streamStates.put(stream, parent.streamStates.get(stream).newSection());
        }
    }

    void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    State newState() {
        HashMap<String, StreamState> sst = new HashMap<String, StreamState>(this.streamStates.size());
        for (String stream : this.streamStates.keySet()) {
            sst.put(stream, this.streamStates.get(stream).newSection());
        }
        return new State(this.env, new HashMap<String, Object>(this.vars), this.streams, sst, this.steps);
    }

    State newError(String error) {
        State next = this.newState();
        next.setError(error);
        return next;
    }

    public State execNext() {
        if (this.current == null || this.error != null) {
            return null;
        }
        if (this.steps <= 0L) {
            return this.newError("A program el\u00e9rte a fut\u00e1si l\u00e9p\u00e9sek korl\u00e1tj\u00e1t.");
        }
        --this.steps;
        return this.current.execute(this);
    }

    public void setStatement(Statement stmt) {
        this.current = stmt;
        while (this.current instanceof CommentStatement) {
            this.current = this.current.getNext();
        }
    }

    void setVar(String name, Object value) {
        this.vars.put(name, value);
    }

    public Object getVar(String name) {
        return this.vars.get(name);
    }

    public Type getVarType(String name) {
        return this.env.getVarType(name);
    }

    public Set<String> getVarNames() {
        return this.vars.keySet();
    }

    public StreamData getStream(String name) {
        return this.streams.get(name);
    }

    public Set<String> getStreamNames() {
        return this.streams.keySet();
    }

    public StreamState getStreamState(String name) {
        return this.streamStates.get(name);
    }

    public int getLine() {
        return this.current.getLineIndex();
    }

    public double getRandom(int rndID) {
        Double rnd;
        if (this.randomState == null) {
            this.randomState = new TreeMap<Integer, Double>();
        }
        if ((rnd = this.randomState.get(rndID)) != null) {
            return rnd;
        }
        double d = Math.random();
        this.randomState.put(rndID, d);
        return d;
    }

    void addSubStates(int id, List<State> states) {
        if (this.subStateLists == null) {
            this.subStateLists = new TreeMap<Integer, List<State>>();
        }
        this.subStateLists.put(id, new Vector<State>(states));
    }

    List<State> getSubStates(int id) {
        if (this.subStateLists == null || !this.subStateLists.containsKey(id)) {
            return null;
        }
        return this.subStateLists.get(id);
    }
}

