/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.ParDecl;
import hu.ppke.itk.plang.prog.SubProgram;
import hu.ppke.itk.plang.prog.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

class Signature {
    private Vector<ParDecl> params;
    private Type returns;
    private Error error;
    private int errorInd;

    public static Signature parseSignature(SubProgram.Kind kind, Lexer lex, Environment subEnv) {
        if (!lex.isKeyword("(")) {
            return new Signature(kind, null, null, Error.OPAREN);
        }
        lex.next();
        LinkedList<ParDecl> param = new LinkedList<ParDecl>();
        ParDecl.Kind parKind = ParDecl.Kind.INPUT;
        boolean hasMore = !lex.isKeyword(")");
        while (hasMore) {
            if (lex.isKeyword("be")) {
                parKind = ParDecl.Kind.INPUT;
                lex.next();
            } else if (lex.isKeyword("ki")) {
                parKind = ParDecl.Kind.OUTPUT;
                lex.next();
            }
            param.addAll(ParDecl.parseParDecls(parKind, lex, subEnv));
            if (lex.isKeyword(",")) {
                lex.next();
                continue;
            }
            hasMore = false;
        }
        if (!lex.isKeyword(")")) {
            return new Signature(kind, param, null, Error.CPAREN);
        }
        lex.next();
        Type ret = null;
        if (kind == SubProgram.Kind.FUNC) {
            if (!lex.isKeyword(":")) {
                return new Signature(kind, param, null, Error.NORET);
            }
            lex.next();
            ret = Type.parseType(lex, subEnv);
            if (ret == null) {
                return new Signature(kind, param, null, Error.RETURN);
            }
        }
        return new Signature(kind, param, ret, Error.NONE);
    }

    private Signature(SubProgram.Kind kind, LinkedList<ParDecl> params, Type returns, Error error) {
        this.params = new Vector<ParDecl>(params);
        this.returns = returns;
        this.error = error;
        if (error == Error.NONE) {
            this.errorInd = 0;
            for (ParDecl par : params) {
                if (kind == SubProgram.Kind.FUNC && par.getKind() == ParDecl.Kind.OUTPUT) {
                    error = Error.OUTPAR;
                    break;
                }
                if (par.getError() != null) {
                    error = Error.PARAM;
                    break;
                }
                ++this.errorInd;
            }
        }
    }

    public String render() {
        if (this.error == Error.OPAREN) {
            return ProgramLine.bad("(");
        }
        String s = "(";
        ParDecl.Kind pk = ParDecl.Kind.INPUT;
        Iterator<ParDecl> par = this.params.iterator();
        ParDecl prev = par.hasNext() ? par.next() : null;
        while (prev != null) {
            ParDecl next;
            ParDecl parDecl = next = par.hasNext() ? par.next() : null;
            if (prev.getKind() != pk) {
                s = String.valueOf(s) + (this.error == Error.OUTPAR ? ProgramLine.bad(prev.getKind().toString()) : prev.getKind()) + " ";
                pk = prev.getKind();
            }
            if (next != null && prev.getKind() == next.getKind() && prev.getType() == next.getType()) {
                s = String.valueOf(s) + prev.renderName() + ", ";
            } else {
                s = String.valueOf(s) + prev.renderName() + ": " + prev.renderType();
                if (next != null) {
                    s = String.valueOf(s) + ", ";
                }
            }
            prev = next;
        }
        s = this.error == Error.CPAREN ? String.valueOf(s) + ProgramLine.bad(")") : String.valueOf(s) + ")";
        if (this.error == Error.NORET) {
            s = String.valueOf(s) + ProgramLine.bad(": ???");
        } else if (this.error == Error.RETURN) {
            s = String.valueOf(s) + ": " + ProgramLine.bad("???");
        } else if (this.returns != null) {
            s = String.valueOf(s) + ": " + this.returns.render();
        }
        return s;
    }

    public String getError() {
        if (this.error == Error.PARAM) {
            return this.params.get(this.errorInd).getError();
        }
        return this.error.msg();
    }

    int getParCount() {
        return this.params.size();
    }

    ParDecl getPar(int index) {
        return this.params.get(index);
    }

    private static enum Error {
        NONE(null),
        OPAREN("Hi\u00e1nyzik a param\u00e9terlista nyit\u00f3 z\u00e1r\u00f3jele."),
        CPAREN("Hi\u00e1nyzik a param\u00e9terlista z\u00e1r\u00f3 z\u00e1r\u00f3jele."),
        PARAM(null),
        OUTPAR("F\u00fcggv\u00e9nynek nem lehet kimen\u0151 param\u00e9tere"),
        NORET("Hi\u00e1nyzik az eredm\u00e9ny t\u00edpusa."),
        RETURN("Hib\u00e1s az eredm\u00e9ny t\u00edpusa.");

        String msg;

        private Error(String msg) {
            this.msg = msg;
        }

        String msg() {
            return this.msg;
        }
    }
}

