/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.AssignableExpr;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.FileType;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamState;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class ReadStmt
extends Statement {
    private final String file;
    private Vector<AssignableExpr> exprs;
    private ErrorType errorType;

    public static ReadStmt parseReadStmt(Lexer lex, Environment env) {
        String file = null;
        if (lex.isIdent()) {
            file = lex.getString();
            lex.next();
        }
        if (!lex.isKeyword(":")) {
            return new ReadStmt(file, null, ErrorType.COLON);
        }
        lex.next();
        ErrorType err = ErrorType.NONE;
        LinkedList<AssignableExpr> exprs = new LinkedList<AssignableExpr>();
        exprs.add(AssignableExpr.parseAssignable(lex, env));
        err = ReadStmt.checkError(err, (AssignableExpr)exprs.getLast());
        while (lex.isKeyword(",")) {
            lex.next();
            AssignableExpr e = AssignableExpr.parseAssignable(lex, env);
            exprs.add(e);
            err = ReadStmt.checkError(err, exprs.getLast());
        }
        if (file != null && env.getVarType(file) != FileType.INPUT) {
            return new ReadStmt(file, exprs, ErrorType.TYPE);
        }
        return new ReadStmt(file, exprs, err);
    }

    private static ErrorType checkError(ErrorType err, AssignableExpr expr) {
        if (err != ErrorType.NONE) {
            return err;
        }
        if (expr.getError() != null) {
            return ErrorType.EXPR;
        }
        if (!expr.getType().hasDataIO()) {
            return ErrorType.ETYPE;
        }
        return err;
    }

    private ReadStmt(String file, LinkedList<AssignableExpr> exprs, ErrorType errorType) {
        this.file = file;
        this.exprs = exprs == null ? new Vector(0) : new Vector<AssignableExpr>(exprs);
        this.errorType = errorType;
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return ReadStmt.oneLine(new ReadLine(indent));
    }

    private String getErrorStr() {
        if (this.errorType == ErrorType.COLON) {
            return "Hi\u00e1nyzik a kett\u0151spont az utas\u00edt\u00e1sb\u00f3l.";
        }
        if (this.errorType == ErrorType.TYPE) {
            return "Csak BEF\u00c1JL-b\u00f3l lehet adatokat beolvasni.";
        }
        if (this.errorType == ErrorType.EXPR) {
            for (AssignableExpr e : this.exprs) {
                String err = e.getError();
                if (err == null) continue;
                return err;
            }
        }
        if (this.errorType == ErrorType.ETYPE) {
            for (AssignableExpr e : this.exprs) {
                if (e.getType().hasDataIO()) continue;
                return String.valueOf(e.getType().render()) + " t\u00edpus\u00fa adatot nem lehet beolvasni.";
            }
        }
        return null;
    }

    @Override
    State execute(State state) {
        String name;
        String string = name = this.file == null ? "BEMENET" : (String)state.getVar(this.file);
        if (name.equals("<--LEZART-->")) {
            return state.newError("Nincs megnyitva a f\u00e1jl.");
        }
        StreamData strm = state.getStream(name);
        StreamState sst = state.getStreamState(name);
        LinkedList<Object> values = new LinkedList<Object>();
        for (AssignableExpr e : this.exprs) {
            try {
                if (sst.isEof()) continue;
                values.add(e.getType().readData(strm, sst));
            }
            catch (StreamData.DataError exc) {
                if (this.file == null) {
                    values.add(new BadValue("Nem siker\u00fclt a beolvas\u00e1s."));
                    break;
                }
                sst.setEof();
            }
        }
        state = state.newState();
        for (AssignableExpr e : this.exprs) {
            if (values.isEmpty()) {
                e.assign(state, null);
                continue;
            }
            Object val = values.remove();
            e.assign(state, val);
            if (!(val instanceof BadValue)) continue;
            state.setError("Nem siker\u00fclt a beolvas\u00e1s.");
            return state;
        }
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private static enum ErrorType {
        NONE,
        COLON,
        EXPR,
        TYPE,
        ETYPE;

    }

    private class ReadLine
    extends ProgramLine {
        ReadLine(int ind) {
            super(ind, ReadStmt.this.getErrorStr());
        }

        @Override
        protected String render() {
            String str = String.valueOf(this.indent()) + "BE";
            if (ReadStmt.this.file != null) {
                str = String.valueOf(str) + " " + (ReadStmt.this.errorType == ErrorType.TYPE ? ReadLine.bad(ReadStmt.this.file) : ReadStmt.this.file);
            }
            if (ReadStmt.this.errorType == ErrorType.COLON) {
                return String.valueOf(str) + ReadLine.bad(":");
            }
            str = String.valueOf(str) + ": ";
            String comma = "";
            for (AssignableExpr e : ReadStmt.this.exprs) {
                str = String.valueOf(str) + comma + e.render();
                comma = ", ";
            }
            return str;
        }

        @Override
        public ExprNode getExpr(State state) {
            ExprNode[] chld = new ExprNode[ReadStmt.this.exprs.size()];
            int i = 0;
            for (AssignableExpr e : ReadStmt.this.exprs) {
                chld[i++] = e.getTree(state);
            }
            return new ExprNode(null, "BE:", chld);
        }

        @Override
        public void setLine(int l) {
            ReadStmt.this.setLineIndex(l);
        }
    }
}

