/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.State;

class RandomExpression
extends Expression {
    private ErrorType errorType;
    private Expression bound;
    private int rndID;
    private static int maxRndID = 1;

    static RandomExpression createRandomExpr(Expression bound) {
        if (bound.getError() != null) {
            return new RandomExpression(bound, ErrorType.ARG);
        }
        if (bound.getType() != BasicType.INTEGER) {
            return new RandomExpression(bound, ErrorType.TYPE);
        }
        return new RandomExpression(bound, ErrorType.NONE);
    }

    private RandomExpression(Expression bound, ErrorType errorType) {
        super(BasicType.INTEGER);
        this.bound = bound;
        this.errorType = errorType;
        this.rndID = maxRndID++;
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.ARG) {
            return this.bound.getError();
        }
        if (this.errorType == ErrorType.TYPE) {
            return "A param\u00e9ter nem EG\u00c9SZ t\u00edpus\u00fa.";
        }
        return null;
    }

    @Override
    String render() {
        if (this.errorType != ErrorType.NONE) {
            return ProgramLine.bad("RND " + this.bound.render());
        }
        return "RND " + this.bound.render();
    }

    public String toString() {
        return "RND " + this.bound;
    }

    @Override
    Object getValue(State state) {
        Object bval = this.bound.getValue(state);
        if (bval instanceof BadValue) {
            return bval;
        }
        return (int)((double)((Integer)bval).intValue() * state.getRandom(this.rndID));
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[]{this.bound.getTree(state)};
    }

    private static enum ErrorType {
        NONE,
        ARG,
        TYPE;

    }
}

