/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.FileType;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamState;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class PrintStmt
extends Statement {
    private String file;
    private Vector<Expression> exprs;
    private ErrorType errorType;

    public static PrintStmt parsePrintStmt(Lexer lex, Environment env) {
        String file = null;
        if (lex.isIdent()) {
            file = lex.getString();
            lex.next();
        }
        if (!lex.isKeyword(":")) {
            return new PrintStmt(file, null, ErrorType.COLON);
        }
        lex.next();
        ErrorType err = ErrorType.NONE;
        LinkedList<Expression> exprs = new LinkedList<Expression>();
        exprs.add(Expression.parseExpression(lex, env));
        err = PrintStmt.checkError(err, (Expression)exprs.getLast());
        while (lex.isKeyword(",")) {
            lex.next();
            Expression e = Expression.parseExpression(lex, env);
            exprs.add(e);
            err = PrintStmt.checkError(err, exprs.getLast());
        }
        if (file != null && env.getVarType(file) != FileType.OUTPUT) {
            return new PrintStmt(file, exprs, ErrorType.TYPE);
        }
        return new PrintStmt(file, exprs, err);
    }

    private static ErrorType checkError(ErrorType err, Expression expr) {
        if (err != ErrorType.NONE) {
            return err;
        }
        if (expr.getError() != null) {
            return ErrorType.EXPR;
        }
        if (!expr.getType().hasDataIO()) {
            return ErrorType.ETYPE;
        }
        return err;
    }

    private PrintStmt(String file, List<Expression> exprs, ErrorType errorType) {
        this.file = file;
        this.exprs = exprs == null ? new Vector(0) : new Vector<Expression>(exprs);
        this.errorType = errorType;
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return PrintStmt.oneLine(new PrintLine(indent));
    }

    private String getErrorStr() {
        if (this.errorType == ErrorType.COLON) {
            return "Hi\u00e1nyzik a kett\u0151spont az utas\u00edt\u00e1sb\u00f3l.";
        }
        if (this.errorType == ErrorType.TYPE) {
            return "Csak KIF\u00c1JL-ba lehet adatokat ki\u00edrni.";
        }
        if (this.errorType == ErrorType.EXPR) {
            for (Expression e : this.exprs) {
                String err = e.getError();
                if (err == null) continue;
                return err;
            }
        }
        if (this.errorType == ErrorType.ETYPE) {
            for (Expression e : this.exprs) {
                if (e.getType().hasDataIO()) continue;
                return String.valueOf(e.getType().render()) + " t\u00edpus\u00fa adatot nem lehet ki\u00edrni.";
            }
        }
        return null;
    }

    @Override
    State execute(State state) {
        String name;
        String string = name = this.file == null ? "KIMENET" : (String)state.getVar(this.file);
        if (name.equals("<--LEZART-->")) {
            return state.newError("Nincs megnyitva a f\u00e1jl.");
        }
        StreamData strm = state.getStream(name);
        StreamState sst = state.getStreamState(name);
        for (Expression e : this.exprs) {
            Object val = e.getValue(state);
            if (val instanceof BadValue) {
                return state.newError(val.toString());
            }
            e.getType().printData(strm, sst, val);
        }
        state = state.newState();
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private static enum ErrorType {
        NONE,
        COLON,
        EXPR,
        TYPE,
        ETYPE;

    }

    private class PrintLine
    extends ProgramLine {
        PrintLine(int ind) {
            super(ind, PrintStmt.this.getErrorStr());
        }

        @Override
        protected String render() {
            String str = String.valueOf(this.indent()) + "KI";
            if (PrintStmt.this.file != null) {
                str = String.valueOf(str) + " " + (PrintStmt.this.errorType == ErrorType.TYPE ? PrintLine.bad(PrintStmt.this.file) : PrintStmt.this.file);
            }
            if (PrintStmt.this.errorType == ErrorType.COLON) {
                return String.valueOf(str) + PrintLine.bad(":");
            }
            str = String.valueOf(str) + ": ";
            String comma = "";
            for (Expression e : PrintStmt.this.exprs) {
                str = String.valueOf(str) + comma + e.render();
                comma = ", ";
            }
            return str;
        }

        @Override
        public ExprNode getExpr(State state) {
            ExprNode[] chld = new ExprNode[PrintStmt.this.exprs.size()];
            int i = 0;
            for (Expression e : PrintStmt.this.exprs) {
                chld[i++] = e.getTree(state);
            }
            return new ExprNode(null, "KI:", chld);
        }

        @Override
        public void setLine(int l) {
            PrintStmt.this.setLineIndex(l);
        }
    }
}

