/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class ParDecl {
    private Kind kind;
    private String name;
    private Type type;
    private Error error;

    private static List<ParDecl> parDecls(Kind kind, List<String> names, Type type, Error error, Environment env) {
        LinkedList<ParDecl> lst = new LinkedList<ParDecl>();
        for (String n : names) {
            lst.add(new ParDecl(kind, n, type, error));
            if (env == null) continue;
            lst.getLast().apply(env);
        }
        return lst;
    }

    static List<ParDecl> parseParDecls(Kind kind, Lexer lex, Environment env) {
        LinkedList<String> names = new LinkedList<String>();
        if (!lex.isIdent()) {
            return Arrays.asList(new ParDecl(kind, null, null, Error.NAME));
        }
        names.add(lex.getString());
        lex.next();
        while (lex.isKeyword(",")) {
            lex.next();
            if (!lex.isIdent()) {
                names.add(null);
                return ParDecl.parDecls(kind, names, null, Error.NAME, null);
            }
            names.add(lex.getString());
            lex.next();
        }
        if (!lex.isKeyword(":")) {
            return ParDecl.parDecls(kind, names, null, Error.COLON, null);
        }
        lex.next();
        Type type = Type.parseType(lex, env);
        if (type == null) {
            return ParDecl.parDecls(kind, names, null, Error.TYPE, null);
        }
        return ParDecl.parDecls(kind, names, type, Error.NONE, env);
    }

    private ParDecl(Kind kind, String name, Type type, Error error) {
        this.kind = kind;
        this.name = name;
        this.type = type;
        this.error = error;
    }

    Kind getKind() {
        return this.kind;
    }

    String getName() {
        return this.name;
    }

    Type getType() {
        return this.type;
    }

    String getError() {
        return this.error.msg();
    }

    String renderName() {
        if (this.name == null) {
            return ProgramLine.bad("???");
        }
        if (this.error == Error.EXIST) {
            return ProgramLine.bad(this.name);
        }
        return this.name;
    }

    String renderType() {
        if (this.type == null) {
            return ProgramLine.bad("???");
        }
        return this.type.render();
    }

    void apply(Environment env) {
        if (this.error == Error.NONE) {
            if (env.hasVar(this.name)) {
                this.error = Error.EXIST;
            } else {
                env.addVar(this.name, this.type);
            }
        }
    }

    private static enum Error {
        NONE(null),
        NAME("Hi\u00e1nyzik a param\u00e9ter neve."),
        COLON("Hi\u00e1nyzik a kett\u0151spont a nevek ut\u00e1n."),
        EXIST("M\u00e1r van ilyen nev\u0171 param\u00e9ter."),
        TYPE("Hib\u00e1s a param\u00e9ter t\u00edpusa.");

        private String msg;

        private Error(String msg) {
            this.msg = msg;
        }

        String msg() {
            return this.msg;
        }
    }

    static enum Kind {
        INPUT("BE"),
        OUTPUT("KI");

        private String str;

        private Kind(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

