/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.FileType;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.StreamKind;
import java.util.List;

class OpenStatement
extends Statement {
    private String var;
    private String name;
    private ErrorType errorType;

    static OpenStatement parseOpenStmt(Lexer lex, Environment env) {
        if (!lex.isIdent()) {
            return new OpenStatement(null, null, ErrorType.FVAR);
        }
        String var = lex.getString();
        lex.next();
        if (!lex.isKeyword(":")) {
            return new OpenStatement(var, null, ErrorType.COLON);
        }
        lex.next();
        if (lex.getType() == Lexer.Token.STRING) {
            String name = lex.getString();
            lex.next();
            if (env.getVarType(var) == FileType.INPUT) {
                env.addStream(StreamKind.INPUT, name);
            } else if (env.getVarType(var) == FileType.OUTPUT) {
                env.addStream(StreamKind.OUTPUT, name);
            } else {
                return new OpenStatement(var, name, ErrorType.FTYPE);
            }
            return new OpenStatement(var, name, ErrorType.NONE);
        }
        return new OpenStatement(var, null, ErrorType.FNAME);
    }

    private OpenStatement(String var, String name, ErrorType errorType) {
        this.var = var;
        this.name = name;
        this.errorType = errorType;
    }

    private String getError() {
        if (this.errorType == ErrorType.FVAR) {
            return "Hi\u00e1nyzik a f\u00e1jlv\u00e1ltoz\u00f3 neve.";
        }
        if (this.errorType == ErrorType.FTYPE) {
            return "A f\u00e1jlt egy KIF\u00c1JL vagy BEF\u00c1JL t\u00edpus\u00fa v\u00e1ltoz\u00f3val kell azonos\u00edtani.";
        }
        if (this.errorType == ErrorType.COLON) {
            return "Hi\u00e1nyzik a kett\u0151spont a v\u00e1ltoz\u00f3 neve ut\u00e1n.";
        }
        if (this.errorType == ErrorType.FNAME) {
            return "A f\u00e1jl nev\u00e9t egy sz\u00f6vegkonstanssal kell megadni.";
        }
        return null;
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return OpenStatement.oneLine(new ProgramLine(indent, this.getError()){

            @Override
            protected String render() {
                if (OpenStatement.this.errorType == ErrorType.FVAR) {
                    return String.valueOf(this.indent()) + "MEGNYIT " + 1.bad("???");
                }
                if (OpenStatement.this.errorType == ErrorType.COLON) {
                    return String.valueOf(this.indent()) + "MEGNYIT " + OpenStatement.this.var + 1.bad(": ???");
                }
                if (OpenStatement.this.errorType == ErrorType.FNAME) {
                    return String.valueOf(this.indent()) + "MEGNYIT " + OpenStatement.this.var + ": " + 1.bad("???");
                }
                if (OpenStatement.this.errorType == ErrorType.FTYPE) {
                    return String.valueOf(this.indent()) + "MEGNYIT " + 1.bad(OpenStatement.this.var) + ": \"" + OpenStatement.this.name + "\"";
                }
                return String.valueOf(this.indent()) + "MEGNYIT " + OpenStatement.this.var + ": \"" + OpenStatement.this.name + "\"";
            }

            @Override
            public void setLine(int l) {
                OpenStatement.this.setLineIndex(l);
            }

            @Override
            public ExprNode getExpr(State state) {
                return ExprNode.EMPTY;
            }
        });
    }

    @Override
    State execute(State state) {
        state = state.newState();
        state.setVar(this.var, this.name);
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private static enum ErrorType {
        NONE,
        FVAR,
        FTYPE,
        COLON,
        FNAME;

    }
}

