/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Declarations;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.Program;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statements;
import hu.ppke.itk.plang.prog.UnparsedLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MainProgram
extends Program {
    private ErrorType errorType;
    private List<String> comments;
    private static Set<String> termKeyw = new HashSet<String>(Arrays.asList("program_vege"));

    public static MainProgram parseMainProgram(Lexer lex) {
        LinkedList<String> comments = new LinkedList<String>();
        while (lex.isKeyword("**")) {
            lex.next();
            comments.add(lex.skip());
        }
        if (!lex.isKeyword("program")) {
            return new MainProgram(ErrorType.HEAD, comments, UnparsedLines.skip(lex, "program_vege"));
        }
        lex.next();
        if (!lex.isIdent()) {
            return new MainProgram(ErrorType.NAME, comments, UnparsedLines.skip(lex, "program_vege"));
        }
        String name = lex.getString();
        lex.next();
        Environment env = new Environment();
        Declarations decls = Declarations.parseDecl(lex, env);
        Statements stmts = Statements.parseStmt(lex, env, termKeyw);
        if (!lex.isKeyword("program_vege")) {
            return new MainProgram(name, comments, decls, stmts, ErrorType.TAIL);
        }
        return new MainProgram(name, comments, decls, stmts, env);
    }

    private MainProgram(ErrorType errType, List<String> comments, UnparsedLines unparsed) {
        this(null, comments, null, null, null, errType, unparsed);
    }

    private MainProgram(String name, List<String> comments, Declarations decl, Statements stmts, ErrorType errType) {
        this(name, comments, decl, stmts, null, errType, null);
    }

    private MainProgram(String name, List<String> comments, Declarations decl, Statements stmts, Environment env) {
        this(name, comments, decl, stmts, env, ErrorType.NONE, null);
    }

    private MainProgram(String name, List<String> comments, Declarations decl, Statements stmts, Environment env, ErrorType errType, UnparsedLines unparsed) {
        super(name, decl, stmts, env, unparsed);
        if (comments != null) {
            this.comments = new ArrayList<String>(comments);
        }
        this.errorType = errType;
        if (this.errorType == ErrorType.NONE && stmts.hasError()) {
            this.errorType = ErrorType.BODY;
        }
    }

    public List<State> runProgram(Map<String, String> input, int maxSteps) {
        State state = new State(this.getEnv(), maxSteps);
        for (String stream : input.keySet()) {
            state.getStream(stream).addContent(input.get(stream));
        }
        return this.runProgram(state);
    }

    @Override
    protected List<ProgramLine> getPrefixLines(int indent) {
        LinkedList<ProgramLine> lst = new LinkedList<ProgramLine>();
        for (String s : this.comments) {
            lst.add(new CommentLine(s));
        }
        return lst;
    }

    @Override
    protected ProgramLine getHeadLine(int indent) {
        return new ProgramHead();
    }

    @Override
    protected ProgramLine getTailLine(int indent) {
        return new ProgramTail();
    }

    @Override
    public boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private String errStr(boolean need) {
        if (!need) {
            return null;
        }
        if (this.errorType == ErrorType.HEAD) {
            return "A programnak a PROGRAM kulcssz\u00f3val kell kezd\u0151dnie.";
        }
        if (this.errorType == ErrorType.NAME) {
            return "Hi\u00e1nyzik a program neve (egy azonos\u00edt\u00f3).";
        }
        if (this.errorType == ErrorType.TAIL) {
            return "A programot a PROGRAM_V\u00c9GE kulcssz\u00f3val kell lez\u00e1rni.";
        }
        return null;
    }

    private class CommentLine
    extends ProgramLine {
        private String str;

        CommentLine(String str) {
            super(0);
            this.str = str;
        }

        @Override
        protected String render() {
            return "** " + this.str;
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, "---", null);
        }

        @Override
        public void setLine(int l) {
        }
    }

    private static enum ErrorType {
        NONE,
        HEAD,
        NAME,
        TAIL,
        BODY;

    }

    private class ProgramHead
    extends ProgramLine {
        ProgramHead() {
            super(0, MainProgram.this.errStr(MainProgram.this.errorType == ErrorType.HEAD || MainProgram.this.errorType == ErrorType.NAME));
        }

        @Override
        protected String render() {
            if (MainProgram.this.errorType == ErrorType.HEAD) {
                return ProgramHead.bad("PROGRAM");
            }
            if (MainProgram.this.errorType == ErrorType.NAME) {
                return "PROGRAM " + ProgramHead.bad("???");
            }
            return "PROGRAM " + MainProgram.this.getName();
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, "---", null);
        }

        @Override
        public void setLine(int l) {
        }
    }

    private class ProgramTail
    extends ProgramLine {
        ProgramTail() {
            super(0, MainProgram.this.errStr(MainProgram.this.errorType == ErrorType.TAIL));
        }

        @Override
        protected String render() {
            if (MainProgram.this.errorType == ErrorType.TAIL) {
                return ProgramTail.bad("PROGRAM_V\u00c9GE");
            }
            return "PROGRAM_V\u00c9GE";
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, state == null ? "---" : "A program v\u00e9get \u00e9rt.", null);
        }

        @Override
        public void setLine(int l) {
            MainProgram.this.setEndLine(l);
        }
    }
}

