/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.Statements;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class Loop
extends Statement {
    private static Set<String> termPre = new HashSet<String>(Arrays.asList("program_vege", "ciklus_vege"));
    private static Set<String> termPost = new HashSet<String>(Arrays.asList("program_vege", "amig"));
    private CheckType checkType;
    private Expression cond;
    private Statements body;
    private ErrorType errorType;
    Statement condStmt = new Statement(){

        @Override
        State execute(State state) {
            Object cval = Loop.this.cond.getValue(state);
            state = state.newState();
            if (cval instanceof BadValue) {
                state.setError(cval.toString());
            } else if (((Boolean)cval).booleanValue()) {
                state.setStatement(Loop.this.body.getFirst());
            } else {
                state.setStatement(this.getNext());
            }
            return state;
        }

        @Override
        List<ProgramLine> getLines(int indent) {
            return null;
        }

        @Override
        boolean hasError() {
            return Loop.this.hasError();
        }
    };

    static Loop parseLoopStmt(Lexer lex, Environment env) {
        if (lex.isKeyword("amig")) {
            lex.next();
            Expression cond = Expression.parseExpression(lex, env);
            Statements body = Statements.parseStmt(lex, env, termPre);
            if (lex.isKeyword("ciklus_vege")) {
                lex.next();
                return new Loop(CheckType.BEFORE, cond, body);
            }
            return new Loop(CheckType.BEFORE, cond, body, ErrorType.TAIL);
        }
        Statements body = Statements.parseStmt(lex, env, termPost);
        if (lex.isKeyword("amig")) {
            lex.next();
            Expression cond = Expression.parseExpression(lex, env);
            return new Loop(CheckType.AFTER, cond, body);
        }
        return new Loop(CheckType.AFTER, null, body, ErrorType.TAIL);
    }

    private Loop(CheckType checkType, Expression cond, Statements body, ErrorType errorType) {
        this.checkType = checkType;
        this.errorType = errorType;
        this.cond = cond;
        this.body = body;
        if (errorType == ErrorType.NONE) {
            if (this.cond != null && this.cond.getError() != null) {
                this.errorType = ErrorType.COND;
            } else if (cond.getType() != BasicType.BOOLEAN) {
                errorType = ErrorType.BOOL;
            } else if (this.body.hasError()) {
                this.errorType = ErrorType.BODY;
            }
        }
    }

    public Loop(CheckType checkType, Expression cond, Statements body) {
        this(checkType, cond, body, ErrorType.NONE);
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        LinkedList<ProgramLine> lines = new LinkedList<ProgramLine>();
        lines.add(new LoopHead(indent));
        lines.addAll(this.body.getLines(indent + 1));
        lines.add(new LoopTail(indent));
        return lines;
    }

    @Override
    void setNext(Statement next) {
        super.setNext(next);
        this.condStmt.setNext(next);
        this.body.getLast().setNext(this.condStmt);
    }

    @Override
    State execute(State state) {
        if (this.checkType == CheckType.BEFORE) {
            return this.condStmt.execute(state);
        }
        return this.body.getFirst().execute(state);
    }

    private String getHeadError() {
        if (this.errorType == ErrorType.BOOL) {
            return "A ciklus felt\u00e9tel\u00e9nek logikai t\u00edpus\u00fanak kell lennie.";
        }
        if (this.checkType == CheckType.BEFORE && this.errorType == ErrorType.COND) {
            return this.cond.getError();
        }
        return null;
    }

    private String getTailError() {
        if (this.errorType == ErrorType.BOOL) {
            return "A ciklus felt\u00e9tel\u00e9nek logikai t\u00edpus\u00fanak kell lennie.";
        }
        if (this.checkType == CheckType.AFTER && this.errorType == ErrorType.COND) {
            return this.cond.getError();
        }
        if (this.errorType == ErrorType.TAIL) {
            if (this.checkType == CheckType.BEFORE) {
                return "Hi\u00e1nyzik a CIKLUS_V\u00c9GE kulcssz\u00f3.";
            }
            return "Hi\u00e1nyzik az AM\u00cdG kulcssz\u00f3.";
        }
        return null;
    }

    @Override
    public int getLineIndex() {
        if (this.checkType == CheckType.AFTER) {
            return this.body.getFirst().getLineIndex();
        }
        return super.getLineIndex();
    }

    @Override
    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private static enum CheckType {
        BEFORE,
        AFTER;

    }

    private static enum ErrorType {
        NONE,
        TAIL,
        COND,
        BOOL,
        BODY;

    }

    private final class LoopHead
    extends ProgramLine {
        LoopHead(int indent) {
            super(indent, Loop.this.getHeadError());
        }

        @Override
        protected String render() {
            if (Loop.this.checkType == CheckType.BEFORE) {
                if (Loop.this.errorType == ErrorType.BOOL) {
                    return String.valueOf(this.indent()) + "CIKLUS AM\u00cdG " + LoopHead.bad(Loop.this.cond.render());
                }
                return String.valueOf(this.indent()) + "CIKLUS AM\u00cdG " + Loop.this.cond.render();
            }
            return String.valueOf(this.indent()) + "CIKLUS";
        }

        @Override
        public void setLine(int l) {
            if (Loop.this.checkType == CheckType.BEFORE) {
                Loop.this.setLineIndex(l);
                Loop.this.condStmt.setLineIndex(l);
            }
        }

        @Override
        public ExprNode getExpr(State state) {
            if (Loop.this.checkType == CheckType.BEFORE) {
                return Loop.this.cond.getTree(state);
            }
            return ExprNode.EMPTY;
        }
    }

    private final class LoopTail
    extends ProgramLine {
        LoopTail(int indent) {
            super(indent, Loop.this.getTailError());
        }

        @Override
        protected String render() {
            if (Loop.this.checkType == CheckType.BEFORE) {
                if (Loop.this.errorType == ErrorType.TAIL) {
                    return String.valueOf(this.indent()) + LoopTail.bad("CIKLUS_V\u00c9GE");
                }
                return String.valueOf(this.indent()) + "CIKLUS_V\u00c9GE";
            }
            if (Loop.this.errorType == ErrorType.TAIL) {
                return String.valueOf(this.indent()) + LoopTail.bad("AM\u00cdG ???");
            }
            if (Loop.this.errorType == ErrorType.BOOL) {
                return String.valueOf(this.indent()) + "AM\u00cdG " + LoopTail.bad(Loop.this.cond.render());
            }
            return String.valueOf(this.indent()) + "AM\u00cdG " + Loop.this.cond.render();
        }

        @Override
        public void setLine(int l) {
            if (Loop.this.checkType == CheckType.AFTER) {
                Loop.this.condStmt.setLineIndex(l);
            }
        }

        @Override
        public ExprNode getExpr(State state) {
            if (Loop.this.checkType == CheckType.AFTER && Loop.this.cond != null) {
                return Loop.this.cond.getTree(state);
            }
            return ExprNode.EMPTY;
        }
    }
}

