/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Set;

public final class Lexer {
    private Token type;
    private String sval;
    private double nval;
    private static final Set<String> keywords;
    private static final Set<String> keywordPrefs;
    private StreamTokenizer tok;
    private static Set<String> emptySet;

    static {
        String[] kwd = new String[]{"program", "program_vege", "eljaras", "eljaras_vege", "fuggveny", "fuggveny_vege", "valtozok", "ha", "akkor", "ha_vege", "kulonben", "ciklus", "amig", "ciklus_vege", "egesz", "valos", "szoveg", "karakter", "logikai", "igaz", "hamis", "sv", "ki", "be", ",", ":", "+", "-", "*", "/", "^", "@", "div", "mod", "(", ")", "[", "]", "|", "**", ":=", "=", "/=", "<", ">", "<=", ">=", "sin", "cos", "tan", "log", "exp", "rnd", "arcsin", "arccos", "arctan", "kis", "nagy", "kerek", "betu", "szam", "nem", "es", "vagy", "kifajl", "befajl", "megnyit", "lezar", "vege"};
        HashSet<String> s = new HashSet<String>();
        int i = 0;
        while (i < kwd.length) {
            s.add(kwd[i]);
            ++i;
        }
        keywords = s;
        String[] prefs = new String[]{":", "/", "!", "<", ">", "*"};
        s = new HashSet();
        i = 0;
        while (i < prefs.length) {
            s.add(prefs[i]);
            ++i;
        }
        keywordPrefs = s;
        emptySet = new HashSet<String>(0);
    }

    double getNumber() {
        return this.nval;
    }

    String getString() {
        if (this.type == Token.IDENT) {
            return this.sval.toLowerCase();
        }
        return this.sval;
    }

    public Lexer(Reader r) {
        this.tok = new StreamTokenizer(r);
        this.tok.lowerCaseMode(false);
        this.tok.eolIsSignificant(true);
        this.tok.ordinaryChar(47);
        this.tok.ordinaryChar(45);
        this.tok.wordChars(95, 95);
        this.type = Token.INIT;
        this.next();
    }

    void next() {
        if (this.type == Token.EOF) {
            return;
        }
        try {
            this.tok.nextToken();
            switch (this.tok.ttype) {
                case -1: {
                    this.type = Token.EOF;
                    break;
                }
                case -2: {
                    this.type = Token.NUMBER;
                    this.nval = this.tok.nval;
                    this.sval = (double)((int)this.tok.nval) == this.tok.nval ? Integer.toString((int)this.tok.nval) : Double.toString(this.tok.nval);
                    break;
                }
                case -3: {
                    String word = this.deacc(this.tok.sval.toLowerCase());
                    if (keywords.contains(word)) {
                        this.type = Token.KEYWORD;
                        this.sval = word;
                        break;
                    }
                    this.type = Token.IDENT;
                    this.sval = this.tok.sval;
                    break;
                }
                case 10: {
                    this.next();
                    return;
                }
                default: {
                    if (this.tok.sval != null) {
                        this.type = this.tok.ttype == 34 ? Token.STRING : Token.CHAR;
                        this.sval = this.tok.sval;
                        int i = 0;
                        while (i < this.sval.length()) {
                            if (this.sval.charAt(i) < ' ') {
                                this.sval = this.sval.replace(this.sval.charAt(i), ' ');
                            }
                            ++i;
                        }
                        break;
                    }
                    String ch = new String(new char[]{(char)this.tok.ttype});
                    if (keywordPrefs.contains(ch)) {
                        this.tok.nextToken();
                        if (this.tok.ttype >= 0 && keywords.contains(String.valueOf(ch) + (char)this.tok.ttype)) {
                            ch = String.valueOf(ch) + (char)this.tok.ttype;
                        } else {
                            this.tok.pushBack();
                        }
                    }
                    this.type = keywords.contains(ch) ? Token.KEYWORD : Token.IDENT;
                    this.sval = ch;
                    break;
                }
            }
        }
        catch (IOException e) {
            this.type = Token.EOF;
            System.err.println(e.getMessage());
        }
    }

    String skip() {
        return this.skip(emptySet);
    }

    String skip(Set<String> termKeyw) {
        if (termKeyw.contains(this.deacc(this.sval))) {
            return "";
        }
        String s = this.type == Token.STRING ? String.valueOf('\"') + this.sval + '\"' : this.sval;
        try {
            this.tok.nextToken();
            while (this.tok.ttype != -1 && this.tok.ttype != 10) {
                if (this.tok.ttype == -2) {
                    s = String.valueOf(s) + " " + ((double)((int)this.tok.nval) == this.tok.nval ? Integer.toString((int)this.tok.nval) : Double.toString(this.tok.nval));
                } else if (this.tok.ttype == -3) {
                    if (termKeyw.contains(this.deacc(this.tok.sval.toLowerCase()))) {
                        this.tok.pushBack();
                        break;
                    }
                    s = String.valueOf(s) + " " + this.tok.sval;
                } else {
                    s = this.tok.sval != null ? String.valueOf(s) + (char)this.tok.ttype + this.tok.sval + (char)this.tok.ttype : String.valueOf(s) + (char)this.tok.ttype;
                }
                this.tok.nextToken();
            }
            this.next();
        }
        catch (IOException e) {
            this.type = Token.EOF;
            System.err.println(e.getMessage());
        }
        return s;
    }

    private String deacc(String word) {
        char[] accent = new char[]{'\u00e1', '\u00e9', '\u00ed', '\u00f3', '\u00f6', '\u0151', '\u00fa', '\u00fc', '\u0171'};
        char[] noacc = new char[]{'a', 'e', 'i', 'o', 'o', 'o', 'u', 'u', 'u'};
        int i = 0;
        while (i < accent.length) {
            word = word.replace(accent[i], noacc[i]);
            ++i;
        }
        return word;
    }

    public boolean isKeyword(String kw) {
        return this.type == Token.KEYWORD && this.sval.equals(kw);
    }

    public boolean isKeyword(Set<String> termKeyw) {
        return this.type == Token.KEYWORD && termKeyw.contains(this.sval);
    }

    public boolean isIdent() {
        return this.type == Token.IDENT;
    }

    public boolean isEof() {
        return this.type == Token.EOF;
    }

    public boolean isData() {
        return this.type == Token.CHAR || this.type == Token.STRING || this.type == Token.NUMBER;
    }

    public Token getType() {
        return this.type;
    }

    public static enum Token {
        INIT,
        EOF,
        KEYWORD,
        STRING,
        CHAR,
        NUMBER,
        IDENT;

    }
}

