/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Accessor;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BinaryOperator;
import hu.ppke.itk.plang.prog.EmptyValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;

class Indexer
extends Accessor {
    private Expression index;
    private Accessor next;
    private Type baseType;
    private ErrorType errorType;

    static Indexer parseIndexer(Lexer lex, Environment env, Type baseType) {
        lex.next();
        Expression index = Expression.parseExpression(lex, env);
        if (!lex.isKeyword("]")) {
            return new Indexer(baseType, index, null, ErrorType.BRACKET);
        }
        lex.next();
        Type parType = baseType == null ? null : baseType.operatorType(BinaryOperator.BRACKET, index.getType());
        return new Indexer(baseType, index, Accessor.parseAccessors(lex, env, parType));
    }

    private Indexer(Type baseType, Expression index, Accessor next, ErrorType errorType) {
        this.index = index;
        this.next = next;
        this.baseType = baseType;
        this.errorType = errorType;
        if (errorType == ErrorType.NONE) {
            if (baseType == null) {
                this.errorType = ErrorType.BASE;
            } else if (index.getError() != null) {
                this.errorType = ErrorType.INDEX;
            } else if (!baseType.hasAccessor(BinaryOperator.BRACKET, index.getType())) {
                this.errorType = ErrorType.TYPE;
            } else if (next.getError() != null) {
                this.errorType = ErrorType.NEXT;
            }
        }
    }

    private Indexer(Type baseType, Expression index, Accessor next) {
        this(baseType, index, next, ErrorType.NONE);
    }

    @Override
    Object access(State state, Object baseValue, Object newValue) {
        if (baseValue instanceof EmptyValue) {
            return new BadValue("Az alapkifejez\u00e9s nem kapott kezd\u0151\u00e9rt\u00e9ket.");
        }
        Object ind = this.index.getValue(state);
        if (ind instanceof BadValue) {
            return ind;
        }
        Object oldValue = this.baseType.apply(BinaryOperator.BRACKET, this.index.getType(), baseValue, ind);
        if (oldValue instanceof BadValue && !(oldValue instanceof EmptyValue)) {
            return oldValue;
        }
        newValue = this.next.access(state, oldValue, newValue);
        return this.baseType.access(BinaryOperator.BRACKET, baseValue, ind, newValue);
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.BRACKET) {
            return "[" + this.index.render() + ProgramLine.bad(" ??? ");
        }
        if (this.errorType == ErrorType.TYPE) {
            return String.valueOf(ProgramLine.bad("[" + this.index.render() + "]")) + this.next.render();
        }
        return "[" + this.index.render() + "]" + this.next.render();
    }

    public String toString() {
        return "[" + this.index + "]" + this.next;
    }

    @Override
    ExprNode getTree(State state, String pref, ExprNode subExpr) {
        String s = String.valueOf(pref) + "[" + this.index.render() + "]";
        return this.next.getTree(state, s, new ExprNode(s, new ExprNode[]{subExpr, this.index.getTree(state)}, null));
    }

    @Override
    String getError() {
        if (this.errorType == ErrorType.BRACKET) {
            return "Hi\u00e1nyzik a z\u00e1r\u00f3 sz\u00f6gletes z\u00e1r\u00f3jel.";
        }
        if (this.errorType == ErrorType.INDEX) {
            return this.index.getError();
        }
        if (this.errorType == ErrorType.TYPE) {
            return String.valueOf(this.baseType.render()) + " t\u00edpusnak " + this.index.getType().render() + " t\u00edpus\u00fa \"[ ]\" oper\u00e1toron kereszt\u00fcl nem lehet \u00e9rt\u00e9ket adni.";
        }
        if (this.errorType == ErrorType.NEXT) {
            return this.next.getError();
        }
        return null;
    }

    @Override
    Type getType() {
        return this.next == null ? null : this.next.getType();
    }

    private static enum ErrorType {
        NONE,
        BRACKET,
        TYPE,
        NEXT,
        BASE,
        INDEX;

    }
}

