/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.BinOpExpression;
import hu.ppke.itk.plang.prog.BinaryOperator;
import hu.ppke.itk.plang.prog.ConstExpression;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.EofExpression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.ParenExpression;
import hu.ppke.itk.plang.prog.RandomExpression;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.SubstringExpression;
import hu.ppke.itk.plang.prog.Type;
import hu.ppke.itk.plang.prog.UnOpExpression;
import hu.ppke.itk.plang.prog.UnaryOperator;
import hu.ppke.itk.plang.prog.VarExpression;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

abstract class Expression {
    private Type type;

    static Expression parseExpression(Lexer lex, Environment env) {
        ExprList lst = new ExprList(Expression.parseRelExpr(lex, env));
        while (true) {
            if (lex.isKeyword("es")) {
                lex.next();
                lst.add(BinaryOperator.AND, Expression.parseRelExpr(lex, env));
                continue;
            }
            if (!lex.isKeyword("vagy")) break;
            lex.next();
            lst.add(BinaryOperator.OR, Expression.parseRelExpr(lex, env));
        }
        return lst.merge();
    }

    private static Expression parseRelExpr(Lexer lex, Environment env) {
        ExprList lst = new ExprList(Expression.parseAddExpr(lex, env));
        while (true) {
            if (lex.isKeyword("=")) {
                lex.next();
                lst.add(BinaryOperator.EQUALS, Expression.parseAddExpr(lex, env));
                continue;
            }
            if (lex.isKeyword("/=")) {
                lex.next();
                lst.add(BinaryOperator.SLASHEQ, Expression.parseAddExpr(lex, env));
                continue;
            }
            if (lex.isKeyword("<=")) {
                lex.next();
                lst.add(BinaryOperator.LESSEQ, Expression.parseAddExpr(lex, env));
                continue;
            }
            if (lex.isKeyword(">=")) {
                lex.next();
                lst.add(BinaryOperator.GREATEQ, Expression.parseAddExpr(lex, env));
                continue;
            }
            if (lex.isKeyword("<")) {
                lex.next();
                lst.add(BinaryOperator.LESS, Expression.parseAddExpr(lex, env));
                continue;
            }
            if (!lex.isKeyword(">")) break;
            lex.next();
            lst.add(BinaryOperator.GREATER, Expression.parseAddExpr(lex, env));
        }
        return lst.merge();
    }

    private static Expression parseAddExpr(Lexer lex, Environment env) {
        ExprList lst = new ExprList(Expression.parseMulExpr(lex, env));
        while (true) {
            if (lex.isKeyword("+")) {
                lex.next();
                lst.add(BinaryOperator.PLUS, Expression.parseMulExpr(lex, env));
                continue;
            }
            if (!lex.isKeyword("-")) break;
            lex.next();
            lst.add(BinaryOperator.MINUS, Expression.parseMulExpr(lex, env));
        }
        return lst.merge();
    }

    private static Expression parseMulExpr(Lexer lex, Environment env) {
        ExprList lst = new ExprList(Expression.parsePowExpr(lex, env));
        while (true) {
            if (lex.isKeyword("*")) {
                lex.next();
                lst.add(BinaryOperator.STAR, Expression.parsePowExpr(lex, env));
                continue;
            }
            if (lex.isKeyword("/")) {
                lex.next();
                lst.add(BinaryOperator.SLASH, Expression.parsePowExpr(lex, env));
                continue;
            }
            if (lex.isKeyword("div")) {
                lex.next();
                lst.add(BinaryOperator.DIV, Expression.parsePowExpr(lex, env));
                continue;
            }
            if (!lex.isKeyword("mod")) break;
            lex.next();
            lst.add(BinaryOperator.MOD, Expression.parsePowExpr(lex, env));
        }
        return lst.merge();
    }

    private static Expression parsePowExpr(Lexer lex, Environment env) {
        ExprList lst = new ExprList(Expression.parsePrefixExpr(lex, env));
        while (true) {
            if (lex.isKeyword("^")) {
                lex.next();
                lst.add(BinaryOperator.CIRCFLX, Expression.parsePrefixExpr(lex, env));
                continue;
            }
            if (!lex.isKeyword("@")) break;
            lex.next();
            lst.add(BinaryOperator.AT, Expression.parsePrefixExpr(lex, env));
        }
        return lst.merge();
    }

    private static Expression parsePrefixExpr(Lexer lex, Environment env) {
        UnOpKwd[] unOpKwdArray = UnOpKwd.values();
        int n = unOpKwdArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnOpKwd ok = unOpKwdArray[n2];
            if (lex.isKeyword(ok.kwd)) {
                lex.next();
                return UnOpExpression.createUnOpExpr(Expression.parsePrefixExpr(lex, env), ok.op);
            }
            ++n2;
        }
        if (lex.isKeyword("rnd")) {
            lex.next();
            return RandomExpression.createRandomExpr(Expression.parsePrefixExpr(lex, env));
        }
        if (lex.isKeyword("vege")) {
            lex.next();
            return EofExpression.createEofExpr(lex, env);
        }
        return Expression.parseBasicExpr(lex, env);
    }

    private static Expression parseBasicExpr(Lexer lex, Environment env) {
        if (lex.isData()) {
            if (lex.getType() == Lexer.Token.NUMBER) {
                if (lex.getNumber() == (double)((int)lex.getNumber())) {
                    int n = (int)lex.getNumber();
                    lex.next();
                    return Expression.parsePostfixExpr(lex, env, new ConstExpression(n, BasicType.INTEGER));
                }
                double d = lex.getNumber();
                lex.next();
                return Expression.parsePostfixExpr(lex, env, new ConstExpression(d, BasicType.REAL));
            }
            if (lex.getType() == Lexer.Token.CHAR) {
                String s = lex.getString();
                lex.next();
                return Expression.parsePostfixExpr(lex, env, new ConstExpression(s, BasicType.CHARACTER));
            }
            if (lex.getType() == Lexer.Token.STRING) {
                String s = lex.getString();
                lex.next();
                return Expression.parsePostfixExpr(lex, env, new ConstExpression(s, BasicType.STRING));
            }
        }
        if (lex.isKeyword("igaz")) {
            lex.next();
            return Expression.parsePostfixExpr(lex, env, new ConstExpression("IGAZ", BasicType.BOOLEAN));
        }
        if (lex.isKeyword("hamis")) {
            lex.next();
            return Expression.parsePostfixExpr(lex, env, new ConstExpression("HAMIS", BasicType.BOOLEAN));
        }
        if (lex.isKeyword("sv")) {
            lex.next();
            return Expression.parsePostfixExpr(lex, env, new ConstExpression("\n", BasicType.CHARACTER));
        }
        if (lex.isIdent()) {
            String var = lex.getString();
            lex.next();
            if (!lex.isKeyword("(")) {
                return Expression.parsePostfixExpr(lex, env, VarExpression.parseVarExpr(var, lex, env));
            }
            return new UnparsedExpression(var, lex);
        }
        if (lex.isKeyword("|")) {
            lex.next();
            Expression expr = Expression.parseExpression(lex, env);
            if (lex.isKeyword("|")) {
                lex.next();
                return Expression.parsePostfixExpr(lex, env, UnOpExpression.createUnOpExpr(expr, UnaryOperator.PIPE));
            }
            return new UnparsedExpression(expr.toString(), lex);
        }
        if (lex.isKeyword("(")) {
            lex.next();
            Expression parExpr = Expression.parseExpression(lex, env);
            if (lex.isKeyword(")")) {
                lex.next();
                return Expression.parsePostfixExpr(lex, env, new ParenExpression(parExpr));
            }
            return new UnparsedExpression(parExpr.toString(), lex);
        }
        return new UnparsedExpression("", lex);
    }

    private static Expression parsePostfixExpr(Lexer lex, Environment env, Expression prefix) {
        while (lex.isKeyword("[")) {
            lex.next();
            Expression expr = Expression.parseExpression(lex, env);
            if (lex.isKeyword("]")) {
                lex.next();
                prefix = BinOpExpression.createBinOpExpr(prefix, expr, BinaryOperator.BRACKET);
                continue;
            }
            if (lex.isKeyword(":")) {
                lex.next();
                Expression expr2 = Expression.parseExpression(lex, env);
                if (!lex.isKeyword("]")) {
                    return new UnparsedExpression(String.valueOf(prefix.toString()) + "[" + expr.toString() + ":" + expr2.toString() + " ??? ", lex);
                }
                lex.next();
                return SubstringExpression.createSubstringExpr(prefix, expr, expr2);
            }
            return new UnparsedExpression(String.valueOf(prefix.toString()) + "[" + expr.toString() + " ??? ", lex);
        }
        return prefix;
    }

    protected Expression(Type t) {
        this.type = t;
    }

    public abstract String getError();

    public Type getType() {
        return this.type;
    }

    abstract String render();

    abstract Object getValue(State var1);

    abstract ExprNode[] getChildren(State var1);

    ExprNode getTree(State state) {
        if (state == null) {
            return new ExprNode(null, this.render(), this.getChildren(state));
        }
        Object val = this.getValue(state);
        if (val instanceof BadValue) {
            return new ExprNode("<font color=\"red\">" + val, this.render(), this.getChildren(state));
        }
        return new ExprNode(this.type.render(val), this.render(), this.getChildren(state));
    }

    private static class ExprList {
        private List<Expression> exprs = new LinkedList<Expression>();
        private List<BinaryOperator> ops;

        ExprList(Expression e) {
            this.exprs.add(e);
            this.ops = new LinkedList<BinaryOperator>();
        }

        void add(BinaryOperator op, Expression e) {
            this.exprs.add(e);
            this.ops.add(op);
        }

        Expression merge() {
            Iterator<BinaryOperator> op = this.ops.iterator();
            Iterator<Expression> exp = this.exprs.iterator();
            Expression e = exp.next();
            while (exp.hasNext()) {
                e = BinOpExpression.createBinOpExpr(e, exp.next(), op.next());
            }
            return e;
        }
    }

    private static enum UnOpKwd {
        MINUS("-", UnaryOperator.MINUS),
        NOT("nem", UnaryOperator.NOT),
        SIN("sin", UnaryOperator.SIN),
        COS("cos", UnaryOperator.COS),
        TAN("tan", UnaryOperator.TAN),
        ARCSIN("arcsin", UnaryOperator.ARCSIN),
        ARCCOS("arccos", UnaryOperator.ARCCOS),
        ARCTAN("arctan", UnaryOperator.ARCTAN),
        LOG("log", UnaryOperator.LOG),
        EXP("exp", UnaryOperator.EXP),
        TRUNC("egesz", UnaryOperator.TRUNC),
        ROUND("kerek", UnaryOperator.ROUND),
        REAL("valos", UnaryOperator.REAL),
        LOWER("kis", UnaryOperator.LOWER),
        UPPER("nagy", UnaryOperator.UPPER),
        ISNUM("szam", UnaryOperator.ISNUM),
        ISALPHA("betu", UnaryOperator.ISALPHA);

        final String kwd;
        final UnaryOperator op;

        private UnOpKwd(String kwd, UnaryOperator op) {
            this.kwd = kwd;
            this.op = op;
        }
    }

    private static class UnparsedExpression
    extends Expression {
        String prefix;
        String rest;
        private static Set<String> termExpr = new HashSet<String>(Arrays.asList(",", "akkor", "ha_vege", "kulonben", "ciklus_vege", "amig", "program_vege"));

        UnparsedExpression(String prefix, Lexer lex) {
            super(null);
            this.prefix = prefix;
            if (prefix.length() > 0) {
                prefix = String.valueOf(prefix) + " ";
            }
            this.rest = lex.skip(termExpr);
        }

        @Override
        String render() {
            return String.valueOf(this.prefix) + ProgramLine.bad(this.rest);
        }

        public String toString() {
            return String.valueOf(this.prefix) + this.rest;
        }

        @Override
        Object getValue(State state) {
            return null;
        }

        @Override
        ExprNode getTree(State state) {
            return new ExprNode(null, String.valueOf(this.prefix) + this.rest, null);
        }

        @Override
        public String getError() {
            return "Nem siker\u00fclt \u00e9rtelmezni a kifejez\u00e9st.";
        }

        @Override
        ExprNode[] getChildren(State state) {
            return null;
        }
    }
}

