/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.FileType;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;

class EofExpression
extends Expression {
    private String var;
    private ErrorType errorType;

    static EofExpression createEofExpr(Lexer lex, Environment env) {
        if (!lex.isIdent()) {
            return new EofExpression(null, ErrorType.VAR);
        }
        String var = lex.getString();
        lex.next();
        if (env.getVarType(var) != FileType.INPUT) {
            return new EofExpression(var, ErrorType.TYPE);
        }
        return new EofExpression(var, ErrorType.NONE);
    }

    private EofExpression(String var, ErrorType errorType) {
        super(BasicType.BOOLEAN);
        this.var = var;
        this.errorType = errorType;
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.VAR) {
            return "Hi\u00e1nyzik a f\u00e1jlv\u00e1ltoz\u00f3 neve.";
        }
        if (this.errorType == ErrorType.TYPE) {
            return "Csak a BEF\u00c1JL t\u00edpuson \u00e9rtelmezett a V\u00c9GE m\u0171velet.";
        }
        return null;
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.VAR) {
            return "V\u00c9GE " + ProgramLine.bad("???");
        }
        if (this.errorType == ErrorType.TYPE) {
            return "V\u00c9GE " + ProgramLine.bad(this.var);
        }
        return "V\u00c9GE " + this.var;
    }

    @Override
    Object getValue(State state) {
        String name = (String)state.getVar(this.var);
        if (name.equals("<--LEZART-->")) {
            return new BadValue("Nincs megnyitva a f\u00e1jl.");
        }
        return new Boolean(state.getStreamState(name).isEof());
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[0];
    }

    private static enum ErrorType {
        NONE,
        VAR,
        TYPE;

    }
}

