/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.prog.StreamKind;
import hu.ppke.itk.plang.prog.SubProgram;
import hu.ppke.itk.plang.prog.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class Environment {
    private Map<String, SubProgram> subProgs = new HashMap<String, SubProgram>();
    private Map<String, Type> vars = new HashMap<String, Type>();
    private Map<StreamKind, Set<String>> streamNames;

    public Environment() {
        this.streamNames = new EnumMap<StreamKind, Set<String>>(StreamKind.class);
        this.streamNames.put(StreamKind.INPUT, new TreeSet());
        this.streamNames.get((Object)StreamKind.INPUT).add("BEMENET");
        this.streamNames.put(StreamKind.OUTPUT, new TreeSet());
        this.streamNames.get((Object)StreamKind.OUTPUT).add("KIMENET");
    }

    Environment(Environment parent) {
        this.streamNames = parent.streamNames;
    }

    boolean hasSubProg(String name) {
        return this.subProgs.containsKey(name);
    }

    void addSubProg(SubProgram subPrg) {
        this.subProgs.put(subPrg.getName(), subPrg);
    }

    SubProgram getSubProg(String name) {
        return this.subProgs.get(name);
    }

    boolean hasVar(String name) {
        return this.vars.containsKey(name);
    }

    void addVar(String name, Type type) {
        this.vars.put(name, type);
    }

    public Type getVarType(String name) {
        return this.vars.get(name);
    }

    void addStream(StreamKind kind, String name) {
        this.streamNames.get((Object)kind).add(name);
    }

    public Set<String> getStreams(StreamKind kind) {
        return this.streamNames.get((Object)kind);
    }

    public StreamKind getStreamKind(String stream) {
        for (StreamKind kind : this.streamNames.keySet()) {
            if (!this.streamNames.get((Object)kind).contains(stream)) continue;
            return kind;
        }
        return null;
    }

    Map<String, Object> createVariables() {
        Set<String> names = this.vars.keySet();
        HashMap<String, Object> init = new HashMap<String, Object>();
        for (String name : names) {
            init.put(name, this.vars.get(name).initVal());
        }
        return init;
    }
}

