/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.SubProgram;
import hu.ppke.itk.plang.prog.VarDecl;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class Declarations {
    Vector<SubProgram> subProgs;
    Vector<VarDecl> varDecls;

    private Declarations(List<SubProgram> subProgs, List<VarDecl> varDecls) {
        this.subProgs = new Vector<SubProgram>(subProgs);
        this.varDecls = new Vector<VarDecl>(varDecls);
    }

    static Declarations parseDecl(Lexer lex, Environment env) {
        LinkedList<SubProgram> subProgs = new LinkedList<SubProgram>();
        while (lex.isKeyword("eljaras") || lex.isKeyword("fuggveny")) {
            subProgs.add(SubProgram.parseSubProgram(lex, env));
        }
        LinkedList<VarDecl> varDecls = new LinkedList<VarDecl>();
        if (lex.isKeyword("valtozok")) {
            lex.next();
            if (lex.isKeyword(":")) {
                lex.next();
            }
            varDecls.add(VarDecl.parseVarDecl(lex, env));
            while (lex.isKeyword(",")) {
                varDecls.getLast().setLast(false);
                lex.next();
                varDecls.add(VarDecl.parseVarDecl(lex, env));
            }
        }
        return new Declarations(subProgs, varDecls);
    }

    List<ProgramLine> getLines(int indent) {
        LinkedList<ProgramLine> l = new LinkedList<ProgramLine>();
        for (SubProgram sp : this.subProgs) {
            l.addAll(sp.getLines(indent));
            l.add(ProgramLine.emptyLine);
        }
        if (this.varDecls.isEmpty()) {
            return l;
        }
        l.add(new VarDeclHead(indent));
        int i = 0;
        while (i < this.varDecls.size()) {
            l.add(this.varDecls.elementAt(i).getLine(indent + 1));
            ++i;
        }
        l.add(ProgramLine.emptyLine);
        return l;
    }

    private final class VarDeclHead
    extends ProgramLine {
        VarDeclHead(int ind) {
            super(ind);
        }

        @Override
        protected String render() {
            return String.valueOf(this.indent()) + "V\u00c1LTOZ\u00d3K:";
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, "---", null);
        }

        @Override
        public void setLine(int l) {
        }
    }
}

