/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.State;

class ConstExpression
extends Expression {
    Object value;
    private ErrorType errorType = ErrorType.NONE;

    ConstExpression(String val, BasicType type) {
        super(type);
        if (type == BasicType.CHARACTER && val.length() != 1) {
            this.value = type.constValue("?");
            this.errorType = ErrorType.CHAR;
        } else {
            this.value = type.constValue(val);
        }
    }

    ConstExpression(double val, BasicType type) {
        super(type);
        this.value = type.constValue(val);
    }

    public String toString() {
        return this.getType().toString(this.value);
    }

    @Override
    String render() {
        if (this.errorType != ErrorType.NONE) {
            return ProgramLine.bad(this.toString());
        }
        return this.getType().render(this.value);
    }

    @Override
    Object getValue(State state) {
        return this.value;
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[0];
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.CHAR) {
            return "A karakter konstansnak pontosan egy karakterb\u0151l kell \u00e1llnia.";
        }
        return null;
    }

    private static enum ErrorType {
        CHAR,
        NONE;

    }
}

