/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.Statements;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class Conditional
extends Statement {
    private static Set<String> termIf = new HashSet<String>(Arrays.asList("program_vege", "ha_vege", "kulonben"));
    private static Set<String> termElse = new HashSet<String>(Arrays.asList("program_vege", "ha_vege"));
    private Expression cond;
    private Statements thenBody;
    private Statements elseBody;
    private ErrorType errType;

    static Conditional parseCondStmt(Lexer lex, Environment env) {
        Expression cond = Expression.parseExpression(lex, env);
        if (!lex.isKeyword("akkor")) {
            return new Conditional(cond, null, null, ErrorType.HEAD);
        }
        lex.next();
        Statements thenBody = null;
        Statements elseBody = null;
        thenBody = Statements.parseStmt(lex, env, termIf);
        if (lex.isKeyword("kulonben")) {
            lex.next();
            elseBody = Statements.parseStmt(lex, env, termElse);
        }
        if (!lex.isKeyword("ha_vege")) {
            return new Conditional(cond, thenBody, elseBody, ErrorType.TAIL);
        }
        lex.next();
        return new Conditional(cond, thenBody, elseBody);
    }

    private Conditional(Expression cond, Statements thenBody, Statements elseBody, ErrorType errorType) {
        this.cond = cond;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
        this.errType = errorType;
        if (this.errType == ErrorType.NONE) {
            if (cond == null || cond.getError() != null) {
                this.errType = ErrorType.COND;
            } else if (cond.getType() != BasicType.BOOLEAN) {
                this.errType = ErrorType.BOOL;
            } else if (thenBody.hasError() || this.elseBody != null && this.elseBody.hasError()) {
                this.errType = ErrorType.BODY;
            }
        }
    }

    private Conditional(Expression cond, Statements thenBody, Statements elseBody) {
        this(cond, thenBody, elseBody, ErrorType.NONE);
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        LinkedList<ProgramLine> lines = new LinkedList<ProgramLine>();
        lines.add(new CondHead(indent));
        if (this.thenBody != null) {
            lines.addAll(this.thenBody.getLines(indent + 1));
        }
        if (this.elseBody != null) {
            lines.add(new CondTail(indent, false));
            lines.addAll(this.elseBody.getLines(indent + 1));
        }
        lines.add(new CondTail(indent, true));
        return lines;
    }

    @Override
    State execute(State state) {
        Object cval = this.cond.getValue(state);
        state = state.newState();
        if (cval instanceof BadValue) {
            state.setError(cval.toString());
        } else if (((Boolean)cval).booleanValue()) {
            state.setStatement(this.thenBody.getFirst());
        } else if (this.elseBody != null) {
            state.setStatement(this.elseBody.getFirst());
        } else {
            state.setStatement(this.getNext());
        }
        return state;
    }

    @Override
    void setNext(Statement next) {
        super.setNext(next);
        this.thenBody.getLast().setNext(next);
        if (this.elseBody != null) {
            this.elseBody.getLast().setNext(next);
        }
    }

    private String getHeadError() {
        if (this.errType == ErrorType.HEAD) {
            return "Hi\u00e1nyzik az AKKOR kulcssz\u00f3.";
        }
        if (this.errType == ErrorType.COND) {
            return this.cond.getError();
        }
        if (this.errType == ErrorType.BOOL) {
            return "A felt\u00e9tel nem logikai t\u00edpus\u00fa kifejez\u00e9s.";
        }
        return null;
    }

    private String getTailError() {
        if (this.errType == ErrorType.TAIL) {
            return "Hi\u00e1nyzik a HA_V\u00c9GE kulcssz\u00f3.";
        }
        return null;
    }

    @Override
    boolean hasError() {
        return this.errType != ErrorType.NONE;
    }

    private class CondHead
    extends ProgramLine {
        CondHead(int indent) {
            super(indent, Conditional.this.getHeadError());
        }

        @Override
        protected String render() {
            if (Conditional.this.errType == ErrorType.HEAD) {
                return String.valueOf(this.indent()) + "HA " + Conditional.this.cond.render() + " " + CondHead.bad("AKKOR");
            }
            if (Conditional.this.errType == ErrorType.BOOL) {
                return String.valueOf(this.indent()) + "HA " + CondHead.bad(Conditional.this.cond.render()) + " AKKOR";
            }
            return String.valueOf(this.indent()) + "HA " + Conditional.this.cond.render() + " AKKOR";
        }

        @Override
        public ExprNode getExpr(State state) {
            return Conditional.this.cond.getTree(state);
        }

        @Override
        public void setLine(int l) {
            Conditional.this.setLineIndex(l);
        }
    }

    private class CondTail
    extends ProgramLine {
        private boolean last;

        CondTail(int indent, boolean last) {
            super(indent, last ? Conditional.this.getTailError() : null);
            this.last = last;
        }

        @Override
        protected String render() {
            if (this.last && Conditional.this.errType == ErrorType.TAIL) {
                return String.valueOf(this.indent()) + CondTail.bad("HA_V\u00c9GE");
            }
            return String.valueOf(this.indent()) + (this.last ? "HA_V\u00c9GE" : "K\u00dcL\u00d6NBEN");
        }

        @Override
        public ExprNode getExpr(State state) {
            return ExprNode.EMPTY;
        }

        @Override
        public void setLine(int l) {
        }
    }

    private static enum ErrorType {
        NONE,
        HEAD,
        TAIL,
        BOOL,
        BODY,
        COND;

    }
}

