/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import java.util.List;

class CommentStatement
extends Statement {
    private String text;

    public static CommentStatement parseComment(Lexer lex, Environment env) {
        return new CommentStatement(lex.skip());
    }

    private CommentStatement(String text) {
        this.text = text;
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return CommentStatement.oneLine(new CommentLine(indent));
    }

    private String getErrorStr() {
        return null;
    }

    @Override
    State execute(State state) {
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return false;
    }

    private class CommentLine
    extends ProgramLine {
        CommentLine(int ind) {
            super(ind, CommentStatement.this.getErrorStr());
        }

        @Override
        protected String render() {
            return String.valueOf(this.indent()) + "** " + CommentStatement.this.text;
        }

        @Override
        public ExprNode getExpr(State state) {
            return ExprNode.EMPTY;
        }

        @Override
        public void setLine(int l) {
            CommentStatement.this.setLineIndex(l);
        }
    }
}

