/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.FileType;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import java.util.List;

class CloseStatement
extends Statement {
    private String var;
    private ErrorType errorType;

    static CloseStatement parseCloseStmt(Lexer lex, Environment env) {
        if (lex.isIdent()) {
            String var = lex.getString();
            lex.next();
            if (env.getVarType(var) == FileType.INPUT || env.getVarType(var) == FileType.OUTPUT) {
                return new CloseStatement(var, ErrorType.NONE);
            }
            return new CloseStatement(var, ErrorType.TYPE);
        }
        return new CloseStatement(null, ErrorType.VAR);
    }

    private CloseStatement(String var, ErrorType errorType) {
        this.var = var;
        this.errorType = errorType;
    }

    private String getError() {
        if (this.errorType == ErrorType.VAR) {
            return "Hi\u00e1nyzik a f\u00e1jlv\u00e1ltoz\u00f3 neve.";
        }
        if (this.errorType == ErrorType.TYPE) {
            return "Lez\u00e1rni csak f\u00e1jl t\u00edpus\u00fa v\u00e1ltoz\u00f3t lehet.";
        }
        return null;
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return CloseStatement.oneLine(new ProgramLine(indent, this.getError()){

            @Override
            protected String render() {
                if (CloseStatement.this.errorType == ErrorType.VAR) {
                    return String.valueOf(this.indent()) + "LEZ\u00c1R " + 1.bad("???");
                }
                if (CloseStatement.this.errorType == ErrorType.TYPE) {
                    return String.valueOf(this.indent()) + "LEZ\u00c1R " + 1.bad(CloseStatement.this.var);
                }
                return String.valueOf(this.indent()) + "LEZ\u00c1R " + CloseStatement.this.var;
            }

            @Override
            public void setLine(int l) {
                CloseStatement.this.setLineIndex(l);
            }

            @Override
            public ExprNode getExpr(State state) {
                return ExprNode.EMPTY;
            }
        });
    }

    @Override
    State execute(State state) {
        state = state.newState();
        state.setVar(this.var, "<--LEZART-->");
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private static enum ErrorType {
        NONE,
        VAR,
        TYPE;

    }
}

