/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.AssignableExpr;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.ParDecl;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import hu.ppke.itk.plang.prog.SubProgram;
import hu.ppke.itk.plang.prog.Type;
import java.util.LinkedList;
import java.util.List;

class CallStatement
extends Statement {
    private Error error;
    private int errorInd;
    private String name;
    private List<Param> params;
    private SubProgram subProg;

    static CallStatement parseCallStmt(String ident, Lexer lex, Environment env) {
        lex.next();
        SubProgram sp = env.getSubProg(ident);
        LinkedList<Param> params = new LinkedList<Param>();
        boolean hasMore = !lex.isKeyword(")");
        int errInd = -1;
        Error err = Error.NONE;
        while (hasMore) {
            Object e;
            ParDecl par;
            ParDecl parDecl = par = sp != null && sp.getParamCount() > params.size() ? sp.getParam(params.size()) : null;
            if (par == null || par.getKind() == ParDecl.Kind.INPUT) {
                e = Expression.parseExpression(lex, env);
                if (errInd < 0 && ((Expression)e).getError() != null) {
                    err = Error.PARAM;
                    errInd = params.size();
                } else if (par != null && errInd < 0 && !par.getType().canCopy(((Expression)e).getType())) {
                    err = Error.TYPE;
                    errInd = params.size();
                }
                params.add(new Param((Expression)e));
            } else {
                e = AssignableExpr.parseAssignable(lex, env);
                if (errInd < 0 && ((AssignableExpr)e).getError() != null) {
                    err = Error.PARAM;
                    errInd = params.size();
                } else if (errInd < 0 && !((AssignableExpr)e).getType().canCopy(par.getType())) {
                    err = Error.TYPE;
                    errInd = -1;
                }
                params.add(new Param((AssignableExpr)e));
            }
            if (lex.isKeyword(",")) {
                lex.next();
                continue;
            }
            hasMore = false;
        }
        if (!lex.isKeyword(")")) {
            return new CallStatement(ident, params, Error.PAREN);
        }
        lex.next();
        if (sp == null) {
            return new CallStatement(ident, params, Error.EXIST);
        }
        if (params.size() != sp.getParamCount()) {
            return new CallStatement(ident, params, Error.COUNT);
        }
        if (errInd >= 0) {
            return new CallStatement(ident, params, sp, err, errInd);
        }
        return new CallStatement(ident, params, sp);
    }

    private CallStatement(String name, List<Param> params, SubProgram subProg, Error error, int errInd) {
        this.name = name;
        this.subProg = subProg;
        this.params = params;
        this.error = error;
        this.errorInd = errInd;
    }

    private CallStatement(String name, List<Param> params, Error error) {
        this(name, params, null, error, -1);
    }

    private CallStatement(String name, List<Param> params, SubProgram subProg) {
        this(name, params, subProg, Error.NONE, -1);
    }

    private String getError() {
        if (this.error == Error.PARAM) {
            return this.params.get(this.errorInd).getError();
        }
        if (this.error == Error.TYPE) {
            return String.valueOf(this.params.get(this.errorInd).getType().toString()) + " t\u00edpus\u00fa " + (this.errorInd + 1) + ". param\u00e9ter nem felel meg a v\u00e1rt " + this.subProg.getParam(this.errorInd).getType() + " t\u00edpusnak.";
        }
        return this.error.msg();
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return CallStatement.oneLine(new ProgramLine(indent, this.getError()){

            @Override
            protected String render() {
                String s = this.indent();
                s = CallStatement.this.error == Error.EXIST ? String.valueOf(s) + 1.bad(CallStatement.this.name) + "(" : String.valueOf(s) + CallStatement.this.name + "(";
                String comma = "";
                for (Param p : CallStatement.this.params) {
                    s = String.valueOf(s) + comma + p.render();
                    comma = ", ";
                }
                s = CallStatement.this.error == Error.PAREN ? String.valueOf(s) + 1.bad(")") : String.valueOf(s) + ")";
                return s;
            }

            @Override
            public void setLine(int l) {
                CallStatement.this.setLineIndex(l);
            }

            @Override
            public ExprNode getExpr(State state) {
                if (state == null) {
                    return new ExprNode(String.valueOf(CallStatement.this.name) + "()", null, null);
                }
                return new ExprNode(String.valueOf(CallStatement.this.name) + "()", null, state.getSubStates(0), null);
            }
        });
    }

    @Override
    State execute(State state) {
        Object[] parVal = new Object[this.params.size()];
        int pos = 0;
        for (Param p : this.params) {
            if (p.input != null) {
                parVal[pos] = p.input.getValue(state);
            }
            ++pos;
        }
        List<State> subStates = this.subProg.runProgram(state, parVal);
        state.addSubStates(0, subStates);
        state = state.newState();
        pos = 0;
        for (Param p : this.params) {
            if (p.output != null) {
                p.output.assign(state, parVal[pos]);
            }
            ++pos;
        }
        state.setStatement(this.getNext());
        return state;
    }

    @Override
    boolean hasError() {
        return this.error != Error.NONE;
    }

    private static enum Error {
        NONE(null),
        PAREN("Hi\u00e1nyzik a param\u00e9terlista z\u00e1r\u00f3 z\u00e1r\u00f3jele."),
        EXIST("Nem l\u00e9tezik ilyen nev\u0171 elj\u00e1r\u00e1s."),
        COUNT("A param\u00e9terek sz\u00e1ma nem megfelel\u0151."),
        TYPE(null),
        PARAM(null);

        private String msg;

        private Error(String msg) {
            this.msg = msg;
        }

        String msg() {
            return this.msg;
        }
    }

    private static class Param {
        Expression input;
        AssignableExpr output;

        Param(Expression e) {
            this.input = e;
        }

        Param(AssignableExpr e) {
            this.output = e;
        }

        String render() {
            return this.input != null ? this.input.render() : this.output.render();
        }

        String getError() {
            return this.input != null ? this.input.getError() : this.output.getError();
        }

        Type getType() {
            return this.input != null ? this.input.getType() : this.output.getType();
        }
    }
}

