/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.prog.Expression;

enum BinaryOperator {
    PLUS("+"),
    MINUS("-"),
    STAR("*"),
    SLASH("/"),
    CIRCFLX("^"),
    AT("@"),
    LESS("<"){

        @Override
        String render(Expression a, Expression b) {
            return String.valueOf(a.render()) + " &lt; " + b.render();
        }
    }
    ,
    EQUALS("="),
    GREATER(">"),
    SLASHEQ("/="),
    LESSEQ("<="){

        @Override
        String render(Expression a, Expression b) {
            return String.valueOf(a.render()) + " &lt;= " + b.render();
        }
    }
    ,
    GREATEQ(">="),
    AND("\u00c9S"),
    OR("VAGY"),
    DIV("DIV"),
    MOD("MOD"),
    BRACKET("[ ]"){

        @Override
        String render(String a, String b) {
            return String.valueOf(a) + "[" + b + "]";
        }
    };

    private final String op;

    private BinaryOperator(String op) {
        this.op = op;
    }

    String render(Expression a, Expression b) {
        return this.render(a.render(), b.render());
    }

    String render(String a, String b) {
        return String.valueOf(a) + " " + this.op + " " + b;
    }

    public String toString() {
        return this.op;
    }

    /* synthetic */ BinaryOperator(String string, int n, String string2, BinaryOperator binaryOperator) {
        this(string2);
    }
}

