/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.AndExpression;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.BinaryOperator;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.OrExpression;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;

class BinOpExpression
extends Expression {
    BinaryOperator op;
    Expression left;
    Expression right;
    Type leftType;
    Type rightType;
    ErrorType errorType = ErrorType.NONE;

    static BinOpExpression createBinOpExpr(Expression left, Expression right, BinaryOperator op) {
        Type retType;
        if (left.getError() != null) {
            return new BinOpExpression(left, right, op, ErrorType.LEFT);
        }
        if (right.getError() != null) {
            return new BinOpExpression(left, right, op, ErrorType.RIGHT);
        }
        if (left.getType() == BasicType.BOOLEAN && right.getType() == BasicType.BOOLEAN) {
            if (op == BinaryOperator.AND) {
                return new AndExpression(left, right);
            }
            if (op == BinaryOperator.OR) {
                return new OrExpression(left, right);
            }
        }
        if ((retType = left.getType().operatorType(op, right.getType())) == null) {
            return new BinOpExpression(left, right, op, ErrorType.OPER);
        }
        return new BinOpExpression(left, right, op, retType);
    }

    BinOpExpression(Expression left, Expression right, BinaryOperator op, Type type) {
        super(type);
        this.left = left;
        this.right = right;
        this.leftType = left.getType();
        this.rightType = right.getType();
        this.op = op;
    }

    BinOpExpression(Expression left, Expression right, BinaryOperator op, ErrorType errType) {
        super(null);
        this.left = left;
        this.right = right;
        this.op = op;
        this.errorType = errType;
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.OPER) {
            return ProgramLine.bad(this.op.render(this.left, this.right));
        }
        return this.op.render(this.left, this.right);
    }

    public String toString() {
        return this.op.render(this.left.toString(), this.right.toString());
    }

    @Override
    Object getValue(State state) {
        Object lval = this.left.getValue(state);
        if (lval instanceof BadValue) {
            return lval;
        }
        Object rval = this.right.getValue(state);
        if (rval instanceof BadValue) {
            return rval;
        }
        return this.leftType.apply(this.op, this.rightType, lval, rval);
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[]{this.left.getTree(state), this.right.getTree(state)};
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.LEFT) {
            return this.left.getError();
        }
        if (this.errorType == ErrorType.RIGHT) {
            return this.right.getError();
        }
        if (this.errorType == ErrorType.OPER) {
            return this.left.getType() + " \u00e9s " + this.right.getType() + " t\u00edpusok k\u00f6z\u00f6tt " + "nincs " + (Object)((Object)this.op) + " m\u0171velet \u00e9rtelmezve.";
        }
        return null;
    }

    private static enum ErrorType {
        NONE,
        LEFT,
        RIGHT,
        OPER;

    }
}

