/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BinaryOperator;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamState;
import hu.ppke.itk.plang.prog.Type;
import hu.ppke.itk.plang.prog.UnaryOperator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;

abstract class BasicType
extends Type {
    static final BasicType INTEGER = new BasicType("EG\u00c9SZ", BT.INTEGER){

        @Override
        Object constValue(String val) {
            return "???";
        }

        @Override
        Object constValue(double val) {
            return new Integer((int)val);
        }

        @Override
        Integer readData(StreamData strm, StreamState sst) throws StreamData.DataError {
            return strm.readInteger(sst);
        }
    };
    static final BasicType REAL = new BasicType("VAL\u00d3S", BT.REAL){
        private DecimalFormat form = new DecimalFormat("#0.0#########", new DecimalFormatSymbols(Locale.US));

        @Override
        boolean canCopy(Type type) {
            return type == this || type == INTEGER;
        }

        @Override
        Object copy(Object val) {
            if (val instanceof Integer) {
                return (double)((Integer)val).intValue();
            }
            return val;
        }

        @Override
        public String toString(Object ob) {
            return this.form.format(ob);
        }

        @Override
        Object constValue(String val) {
            return "???";
        }

        @Override
        Object constValue(double val) {
            return new Double(val);
        }

        @Override
        void printData(StreamData str, StreamState sst, Object val) {
            str.append(sst, this.form.format(val));
        }

        @Override
        Double readData(StreamData strm, StreamState sst) throws StreamData.DataError {
            return strm.readReal(sst);
        }
    };
    static final BasicType STRING = new BasicType("SZ\u00d6VEG", BT.STRING){

        @Override
        Object constValue(String val) {
            return val;
        }

        @Override
        Object constValue(double val) {
            return "" + val;
        }

        @Override
        public String toString(Object obj) {
            return "\"" + obj + "\"";
        }

        @Override
        String readData(StreamData strm, StreamState sst) throws StreamData.DataError {
            return strm.readString(sst);
        }

        @Override
        boolean hasAccessor(BinaryOperator op, Type rhs) {
            return op == BinaryOperator.BRACKET && rhs == INTEGER;
        }

        @Override
        Object access(BinaryOperator op, Object oldVal, Object rhs, Object newVal) {
            if (newVal instanceof BadValue) {
                return newVal;
            }
            char[] s = ((String)oldVal).toCharArray();
            s[((Integer)rhs).intValue()] = ((Character)newVal).charValue();
            return new String(s);
        }
    };
    static final BasicType CHARACTER = new BasicType("KARAKTER", BT.CHARACTER){

        @Override
        Object constValue(String val) {
            return new Character(val.charAt(0));
        }

        @Override
        Object constValue(double val) {
            return new Character('?');
        }

        @Override
        public String toString(Object obj) {
            return ((Character)obj).charValue() == '\n' ? "SV" : "'" + obj + "'";
        }

        @Override
        Object readData(StreamData strm, StreamState sst) throws StreamData.DataError {
            return strm.readChar(sst);
        }
    };
    static final BasicType BOOLEAN = new BasicType("LOGIKAI", BT.BOOLEAN){

        @Override
        Object constValue(String val) {
            if (val.equals("IGAZ")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        @Override
        Object constValue(double val) {
            return new Boolean(false);
        }

        @Override
        void printData(StreamData str, StreamState sst, Object val) {
            str.append(sst, (Boolean)val != false ? "igaz" : "hamis");
        }

        @Override
        public String toString(Object obj) {
            return (Boolean)obj != false ? "igaz" : "hamis";
        }

        @Override
        public String render(Object obj) {
            return (Boolean)obj != false ? "IGAZ" : "HAMIS";
        }

        @Override
        Object readData(StreamData strm, StreamState sst) throws StreamData.DataError {
            return strm.readBoolean(sst);
        }
    };
    private static Map<BT, Type> typeObj = new EnumMap<BT, Type>(BT.class);
    private String name;
    private BT btype;
    Map<UnaryOperator, UnFun> unFuns;
    Map<BinaryOperator, Map<BT, BinFun>> binFuns;

    static {
        typeObj.put(BT.INTEGER, INTEGER);
        typeObj.put(BT.REAL, REAL);
        typeObj.put(BT.STRING, STRING);
        typeObj.put(BT.CHARACTER, CHARACTER);
        typeObj.put(BT.BOOLEAN, BOOLEAN);
    }

    private BasicType(String name, BT btype) {
        this.name = name;
        this.btype = btype;
        this.binFuns = new EnumMap<BinaryOperator, Map<BT, BinFun>>(BinaryOperator.class);
        Enum[] enumArray = BinFun.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinFun bf = enumArray[n2];
            if (bf.leftType == btype) {
                if (!this.binFuns.containsKey((Object)bf.op)) {
                    this.binFuns.put(bf.op, new EnumMap(BT.class));
                }
                this.binFuns.get((Object)bf.op).put(bf.rightType, bf);
            }
            ++n2;
        }
        this.unFuns = new EnumMap<UnaryOperator, UnFun>(UnaryOperator.class);
        enumArray = UnFun.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum uf = enumArray[n2];
            if (((UnFun)uf).parType == btype) {
                this.unFuns.put(((UnFun)uf).op, (UnFun)uf);
            }
            ++n2;
        }
    }

    public boolean equals(Object val) {
        return val instanceof BasicType && ((BasicType)val).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    String render() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    boolean canCopy(Type type) {
        return type == this;
    }

    @Override
    Object copy(Object val) {
        return val;
    }

    @Override
    final Object initVal() {
        return null;
    }

    abstract Object constValue(String var1);

    abstract Object constValue(double var1);

    @Override
    Type operatorType(UnaryOperator op) {
        UnFun f = this.unFuns.get((Object)op);
        return f != null ? typeObj.get((Object)f.retType) : null;
    }

    @Override
    Object apply(UnaryOperator op, Object val) {
        return this.unFuns.get((Object)op).fun(val);
    }

    @Override
    Type operatorType(BinaryOperator op, Type rhs) {
        if (rhs instanceof BasicType && this.binFuns.get((Object)op) != null) {
            BinFun f = this.binFuns.get((Object)op).get((Object)((BasicType)rhs).btype);
            return f != null ? typeObj.get((Object)f.retType) : null;
        }
        return null;
    }

    @Override
    Object apply(BinaryOperator op, Type rt, Object left, Object right) {
        return this.binFuns.get((Object)op).get((Object)((BasicType)rt).btype).fun(left, right);
    }

    @Override
    boolean hasAccessor(UnaryOperator op) {
        return false;
    }

    @Override
    Object access(UnaryOperator op, Object oldVal, Object newVal) {
        return null;
    }

    @Override
    boolean hasAccessor(BinaryOperator op, Type rhs) {
        return false;
    }

    @Override
    Object access(BinaryOperator op, Object oldVal, Object rhs, Object newVal) {
        return null;
    }

    @Override
    boolean hasDataIO() {
        return true;
    }

    /* synthetic */ BasicType(String string, BT bT, BasicType basicType) {
        this(string, bT);
    }

    private static enum BT {
        INTEGER,
        REAL,
        STRING,
        CHARACTER,
        BOOLEAN;

    }

    private static enum BinFun {
        IntIntPlus(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return (Integer)l + (Integer)r;
            }
        }
        ,
        IntIntMinus(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.MINUS){

            @Override
            Object fun(Object l, Object r) {
                return (Integer)l - (Integer)r;
            }
        }
        ,
        IntIntTimes(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.STAR){

            @Override
            Object fun(Object l, Object r) {
                return (Integer)l * (Integer)r;
            }
        }
        ,
        IntIntDivide(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.DIV){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)r == 0) {
                    return new BadValue("Oszt\u00e1s null\u00e1val");
                }
                return (Integer)l / (Integer)r;
            }
        }
        ,
        IntIntModulo(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.MOD){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)r == 0) {
                    return new BadValue("Oszt\u00e1s null\u00e1val");
                }
                return (Integer)l % (Integer)r;
            }
        }
        ,
        IntIntPow(BT.INTEGER, BT.INTEGER, BT.INTEGER, BinaryOperator.CIRCFLX){

            @Override
            Object fun(Object l, Object r) {
                return (int)Math.pow(((Integer)l).intValue(), ((Integer)r).intValue());
            }
        }
        ,
        IntIntEquals(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                return l.equals(r);
            }
        }
        ,
        IntIntNotEq(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                return !l.equals(r);
            }
        }
        ,
        IntIntLess(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)l < (Integer)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntIntGreater(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)l > (Integer)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntIntLessEq(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)l <= (Integer)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntIntGreaterEq(BT.INTEGER, BT.INTEGER, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)l >= (Integer)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealPlus(BT.INTEGER, BT.REAL, BT.REAL, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return (double)((Integer)l).intValue() + (Double)r;
            }
        }
        ,
        IntRealMinus(BT.INTEGER, BT.REAL, BT.REAL, BinaryOperator.MINUS){

            @Override
            Object fun(Object l, Object r) {
                return (double)((Integer)l).intValue() - (Double)r;
            }
        }
        ,
        IntRealTimes(BT.INTEGER, BT.REAL, BT.REAL, BinaryOperator.STAR){

            @Override
            Object fun(Object l, Object r) {
                return (double)((Integer)l).intValue() * (Double)r;
            }
        }
        ,
        IntRealDivide(BT.INTEGER, BT.REAL, BT.REAL, BinaryOperator.SLASH){

            @Override
            Object fun(Object l, Object r) {
                return (double)((Integer)l).intValue() / (Double)r;
            }
        }
        ,
        IntRealPow(BT.INTEGER, BT.REAL, BT.REAL, BinaryOperator.CIRCFLX){

            @Override
            Object fun(Object l, Object r) {
                return Math.pow(((Integer)l).intValue(), (Double)r);
            }
        }
        ,
        IntRealEquals(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() == (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealNotEq(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() != (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealLess(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() < (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealGreater(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() > (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealLessEq(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() <= (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        IntRealGreaterEq(BT.INTEGER, BT.REAL, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((double)((Integer)l).intValue() >= (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntPlus(BT.REAL, BT.INTEGER, BT.REAL, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l + (double)((Integer)r).intValue();
            }
        }
        ,
        RealIntMinus(BT.REAL, BT.INTEGER, BT.REAL, BinaryOperator.MINUS){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l - (double)((Integer)r).intValue();
            }
        }
        ,
        RealIntTimes(BT.REAL, BT.INTEGER, BT.REAL, BinaryOperator.STAR){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l * (double)((Integer)r).intValue();
            }
        }
        ,
        RealIntPow(BT.REAL, BT.INTEGER, BT.REAL, BinaryOperator.CIRCFLX){

            @Override
            Object fun(Object l, Object r) {
                return Math.pow((Double)l, ((Integer)r).intValue());
            }
        }
        ,
        RealIntDivide(BT.REAL, BT.INTEGER, BT.REAL, BinaryOperator.SLASH){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l / (double)((Integer)r).intValue();
            }
        }
        ,
        RealIntEquals(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l == (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntNotEq(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l != (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntLess(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l < (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntGreater(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l > (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntLessEq(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l <= (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealIntGreaterEq(BT.REAL, BT.INTEGER, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l >= (double)((Integer)r).intValue()) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealRealPlus(BT.REAL, BT.REAL, BT.REAL, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l + (Double)r;
            }
        }
        ,
        RealRealMinus(BT.REAL, BT.REAL, BT.REAL, BinaryOperator.MINUS){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l - (Double)r;
            }
        }
        ,
        RealRealTimes(BT.REAL, BT.REAL, BT.REAL, BinaryOperator.STAR){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l * (Double)r;
            }
        }
        ,
        RealRealPow(BT.REAL, BT.REAL, BT.REAL, BinaryOperator.CIRCFLX){

            @Override
            Object fun(Object l, Object r) {
                return Math.pow((Double)l, (Double)r);
            }
        }
        ,
        RealRealDivide(BT.REAL, BT.REAL, BT.REAL, BinaryOperator.SLASH){

            @Override
            Object fun(Object l, Object r) {
                return (Double)l / (Double)r;
            }
        }
        ,
        RealRealEquals(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                return ((Double)l).equals(r);
            }
        }
        ,
        RealRealNotEq(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                return !((Double)l).equals(r);
            }
        }
        ,
        RealRealLess(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l < (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealRealGreater(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l > (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealRealLessEq(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l <= (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        RealRealGreaterEq(BT.REAL, BT.REAL, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if ((Double)l >= (Double)r) {
                    return true;
                }
                return false;
            }
        }
        ,
        BooleanEquals(BT.BOOLEAN, BT.BOOLEAN, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                return ((Boolean)l).equals((Boolean)r);
            }
        }
        ,
        BooleanNotEq(BT.BOOLEAN, BT.BOOLEAN, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                return !((Boolean)l).equals((Boolean)r);
            }
        }
        ,
        CharEquals(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                return ((Character)l).equals((Character)r);
            }
        }
        ,
        CharNotEq(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                return !((Character)l).equals((Character)r);
            }
        }
        ,
        CharLess(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if (((Character)l).compareTo((Character)r) < 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        CharGreater(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if (((Character)l).compareTo((Character)r) > 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        CharLessEq(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if (((Character)l).compareTo((Character)r) <= 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        CharGreaterEq(BT.CHARACTER, BT.CHARACTER, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if (((Character)l).compareTo((Character)r) >= 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        StringConcat(BT.STRING, BT.STRING, BT.STRING, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return String.valueOf((String)l) + (String)r;
            }
        }
        ,
        StringCharPlus(BT.STRING, BT.CHARACTER, BT.STRING, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return String.valueOf((String)l) + (Character)r;
            }
        }
        ,
        CharStringPlus(BT.CHARACTER, BT.STRING, BT.STRING, BinaryOperator.PLUS){

            @Override
            Object fun(Object l, Object r) {
                return (Character)l + (String)r;
            }
        }
        ,
        StringEquals(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.EQUALS){

            @Override
            Object fun(Object l, Object r) {
                return ((String)l).equals((String)r);
            }
        }
        ,
        StringNotEq(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.SLASHEQ){

            @Override
            Object fun(Object l, Object r) {
                return !((String)l).equals((String)r);
            }
        }
        ,
        StringLess(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.LESS){

            @Override
            Object fun(Object l, Object r) {
                if (((String)l).compareTo((String)r) < 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        StringGreater(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.GREATER){

            @Override
            Object fun(Object l, Object r) {
                if (((String)l).compareTo((String)r) > 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        StringLessEq(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.LESSEQ){

            @Override
            Object fun(Object l, Object r) {
                if (((String)l).compareTo((String)r) <= 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        StringGreaterEq(BT.STRING, BT.STRING, BT.BOOLEAN, BinaryOperator.GREATEQ){

            @Override
            Object fun(Object l, Object r) {
                if (((String)l).compareTo((String)r) >= 0) {
                    return true;
                }
                return false;
            }
        }
        ,
        StringFindChar(BT.STRING, BT.CHARACTER, BT.INTEGER, BinaryOperator.AT){

            @Override
            Object fun(Object l, Object r) {
                int i = ((String)l).indexOf(((Character)r).charValue());
                return i < 0 ? ((String)l).length() : i;
            }
        }
        ,
        StringFindString(BT.STRING, BT.STRING, BT.INTEGER, BinaryOperator.AT){

            @Override
            Object fun(Object l, Object r) {
                int i = ((String)l).indexOf((String)r);
                return i < 0 ? ((String)l).length() : i;
            }
        }
        ,
        StringIndex(BT.STRING, BT.INTEGER, BT.CHARACTER, BinaryOperator.BRACKET){

            @Override
            Object fun(Object l, Object r) {
                if ((Integer)r < 0 || ((String)l).length() <= (Integer)r) {
                    return new BadValue("Hib\u00e1s sz\u00f6vegindex");
                }
                return Character.valueOf(((String)l).charAt((Integer)r));
            }
        };

        final BT leftType;
        final BT rightType;
        final BT retType;
        final BinaryOperator op;

        private BinFun(BT leftType, BT rightType, BT retType, BinaryOperator op) {
            this.leftType = leftType;
            this.rightType = rightType;
            this.retType = retType;
            this.op = op;
        }

        abstract Object fun(Object var1, Object var2);
    }

    private static enum UnFun {
        IntMinus(BT.INTEGER, BT.INTEGER, UnaryOperator.MINUS){

            @Override
            Object fun(Object par) {
                return -((Integer)par).intValue();
            }
        }
        ,
        IntAbs(BT.INTEGER, BT.INTEGER, UnaryOperator.PIPE){

            @Override
            Object fun(Object par) {
                return Math.abs((Integer)par);
            }
        }
        ,
        IntReal(BT.INTEGER, BT.REAL, UnaryOperator.REAL){

            @Override
            Object fun(Object par) {
                return ((Integer)par).doubleValue();
            }
        }
        ,
        RealMinus(BT.REAL, BT.REAL, UnaryOperator.MINUS){

            @Override
            Object fun(Object par) {
                return -((Double)par).doubleValue();
            }
        }
        ,
        RealAbs(BT.REAL, BT.REAL, UnaryOperator.PIPE){

            @Override
            Object fun(Object par) {
                return Math.abs((Double)par);
            }
        }
        ,
        Trunc(BT.REAL, BT.INTEGER, UnaryOperator.TRUNC){

            @Override
            Object fun(Object par) {
                return (int)((Double)par).doubleValue();
            }
        }
        ,
        Round(BT.REAL, BT.INTEGER, UnaryOperator.ROUND){

            @Override
            Object fun(Object par) {
                return (int)Math.round((Double)par);
            }
        }
        ,
        Sine(BT.REAL, BT.REAL, UnaryOperator.SIN){

            @Override
            Object fun(Object par) {
                return Math.sin((Double)par);
            }
        }
        ,
        Cosine(BT.REAL, BT.REAL, UnaryOperator.COS){

            @Override
            Object fun(Object par) {
                return Math.cos((Double)par);
            }
        }
        ,
        Tangent(BT.REAL, BT.REAL, UnaryOperator.TAN){

            @Override
            Object fun(Object par) {
                return Math.tan((Double)par);
            }
        }
        ,
        ArcSine(BT.REAL, BT.REAL, UnaryOperator.ARCSIN){

            @Override
            Object fun(Object par) {
                return Math.asin((Double)par);
            }
        }
        ,
        ArcCosine(BT.REAL, BT.REAL, UnaryOperator.ARCCOS){

            @Override
            Object fun(Object par) {
                return Math.acos((Double)par);
            }
        }
        ,
        ArcTangent(BT.REAL, BT.REAL, UnaryOperator.ARCTAN){

            @Override
            Object fun(Object par) {
                return Math.atan((Double)par);
            }
        }
        ,
        Logarithm(BT.REAL, BT.REAL, UnaryOperator.LOG){

            @Override
            Object fun(Object par) {
                return Math.log((Double)par);
            }
        }
        ,
        Exponent(BT.REAL, BT.REAL, UnaryOperator.EXP){

            @Override
            Object fun(Object par) {
                return Math.exp((Double)par);
            }
        }
        ,
        BoolNot(BT.BOOLEAN, BT.BOOLEAN, UnaryOperator.NOT){

            @Override
            Object fun(Object par) {
                return (Boolean)par == false;
            }
        }
        ,
        CharLower(BT.CHARACTER, BT.CHARACTER, UnaryOperator.LOWER){

            @Override
            Object fun(Object par) {
                return Character.valueOf(Character.toLowerCase(((Character)par).charValue()));
            }
        }
        ,
        CharUpper(BT.CHARACTER, BT.CHARACTER, UnaryOperator.UPPER){

            @Override
            Object fun(Object par) {
                return Character.valueOf(Character.toUpperCase(((Character)par).charValue()));
            }
        }
        ,
        CharIsNum(BT.CHARACTER, BT.BOOLEAN, UnaryOperator.ISNUM){

            @Override
            Object fun(Object par) {
                return Character.isDigit(((Character)par).charValue());
            }
        }
        ,
        CharIsAlpha(BT.CHARACTER, BT.BOOLEAN, UnaryOperator.ISALPHA){

            @Override
            Object fun(Object par) {
                return Character.isLetter(((Character)par).charValue());
            }
        }
        ,
        StringLength(BT.STRING, BT.INTEGER, UnaryOperator.PIPE){

            @Override
            Object fun(Object par) {
                return ((String)par).length();
            }
        };

        final BT parType;
        final BT retType;
        final UnaryOperator op;

        private UnFun(BT parType, BT retType, UnaryOperator op) {
            this.parType = parType;
            this.retType = retType;
            this.op = op;
        }

        abstract Object fun(Object var1);
    }
}

