/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.AssignableExpr;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import java.util.List;

class Assignment
extends Statement {
    private AssignableExpr leftSide;
    private Expression expr;
    private String error;
    private ErrType errType = ErrType.NONE;

    Assignment(AssignableExpr lhs, Expression expr, Environment env) {
        this.leftSide = lhs;
        this.expr = expr;
        if (this.leftSide.getError() != null) {
            this.error = this.leftSide.getError();
            this.errType = ErrType.LHS;
        } else if (expr.getError() != null) {
            this.error = expr.getError();
            this.errType = ErrType.EXPR;
        } else if (!this.leftSide.getType().canCopy(expr.getType())) {
            this.error = String.valueOf(this.leftSide.getType().render()) + " \u00e9s " + expr.getType() + " t\u00edpusok k\u00f6z\u00f6tt nem v\u00e9gezhet\u0151 el az \u00e9rt\u00e9kad\u00e1s.";
            this.errType = ErrType.TYPE;
        }
    }

    @Override
    List<ProgramLine> getLines(int indent) {
        return Assignment.oneLine(new AssignmentLine(indent));
    }

    @Override
    State execute(State state) {
        Object rhs = this.expr.getValue(state);
        state = state.newState();
        this.leftSide.assign(state, rhs);
        if (state.getError() == null && rhs instanceof BadValue) {
            state.setError(rhs.toString());
        } else {
            state.setStatement(this.getNext());
        }
        return state;
    }

    @Override
    boolean hasError() {
        return this.errType != ErrType.NONE;
    }

    private class AssignmentLine
    extends ProgramLine {
        AssignmentLine(int indent) {
            super(indent, Assignment.this.error);
        }

        @Override
        protected String render() {
            if (Assignment.this.errType == ErrType.TYPE) {
                return String.valueOf(this.indent()) + Assignment.this.leftSide.render() + AssignmentLine.bad(" := ") + Assignment.this.expr.render();
            }
            return String.valueOf(this.indent()) + Assignment.this.leftSide.render() + " := " + Assignment.this.expr.render();
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, String.valueOf(Assignment.this.leftSide.render()) + " := " + Assignment.this.expr.render(), new ExprNode[]{Assignment.this.leftSide.getTree(state), Assignment.this.expr.getTree(state)});
        }

        @Override
        public void setLine(int l) {
            Assignment.this.setLineIndex(l);
        }
    }

    static enum ErrType {
        NONE,
        LHS,
        EXPR,
        TYPE;

    }
}

