/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Accessor;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.EmptyValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;

class AssignableExpr {
    private String varName;
    private Accessor accessor;
    private ErrorType errorType;

    static AssignableExpr parseAssignable(Lexer lex, Environment env) {
        if (!lex.isIdent()) {
            return new AssignableExpr("", null, ErrorType.IDENT);
        }
        String prefix = lex.getString();
        lex.next();
        return AssignableExpr.parseAssignable(prefix, lex, env);
    }

    static AssignableExpr parseAssignable(String prefix, Lexer lex, Environment env) {
        Type baseType = env.getVarType(prefix);
        Accessor acc = Accessor.parseAccessors(lex, env, baseType);
        if (baseType == null) {
            return new AssignableExpr(prefix, acc, ErrorType.VAR);
        }
        return new AssignableExpr(prefix, acc);
    }

    public AssignableExpr(String varName, Accessor accessor) {
        this(varName, accessor, ErrorType.NONE);
    }

    public AssignableExpr(String varName, Accessor accessor, ErrorType errorType) {
        this.varName = varName;
        this.accessor = accessor;
        this.errorType = errorType;
        if (errorType == ErrorType.NONE && accessor.getError() != null) {
            this.errorType = ErrorType.ACC;
        }
    }

    String getError() {
        if (this.errorType == ErrorType.IDENT) {
            return "Hi\u00e1nyzik egy v\u00e1ltoz\u00f3n\u00e9v.";
        }
        if (this.errorType == ErrorType.VAR) {
            return "Nincs \"" + this.varName + "\" nev\u0171 v\u00e1ltoz\u00f3.";
        }
        if (this.errorType == ErrorType.ACC) {
            return this.accessor.getError();
        }
        return null;
    }

    Type getType() {
        return this.accessor == null ? null : this.accessor.getType();
    }

    String render() {
        if (this.errorType == ErrorType.IDENT) {
            return ProgramLine.bad(" ??? ");
        }
        if (this.errorType == ErrorType.VAR) {
            return String.valueOf(ProgramLine.bad(this.varName)) + this.accessor.render();
        }
        return String.valueOf(this.varName) + this.accessor.render();
    }

    public String toString() {
        if (this.accessor == null) {
            return this.varName;
        }
        return String.valueOf(this.varName) + this.accessor;
    }

    ExprNode getTree(State state) {
        return this.accessor.getTree(state, this.varName, new ExprNode(this.varName, new ExprNode[0], null));
    }

    void assign(State state, Object value) {
        Object newVal;
        Object var = state.getVar(this.varName);
        if (var == null) {
            var = new EmptyValue("\"" + this.varName + "\" v\u00e1ltoz\u00f3 nem kapott kezd\u0151\u00e9rt\u00e9ket.");
        }
        if ((newVal = this.accessor.access(state, var, value)) instanceof BadValue) {
            state.setError(newVal.toString());
        } else {
            state.setVar(this.varName, newVal);
        }
    }

    private static enum ErrorType {
        NONE,
        VAR,
        IDENT,
        ACC;

    }
}

