/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.BinaryOperator;
import hu.ppke.itk.plang.prog.EmptyValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamState;
import hu.ppke.itk.plang.prog.Type;
import hu.ppke.itk.plang.prog.UnaryOperator;
import java.util.Vector;

class ArrayType
extends Type {
    private Type baseType;
    private int bound;
    private ErrorType errorType;

    static ArrayType parseArrayType(Type baseType, Lexer lex, Environment env) {
        lex.next();
        if (lex.getType() == Lexer.Token.NUMBER && lex.getNumber() == (double)((int)lex.getNumber())) {
            int bound = (int)lex.getNumber();
            lex.next();
            if (lex.isKeyword("]")) {
                lex.next();
                return new ArrayType(lex.isKeyword("[") ? ArrayType.parseArrayType(baseType, lex, env) : baseType, bound, ErrorType.NONE);
            }
            return new ArrayType(baseType, bound, ErrorType.BRACKET);
        }
        return new ArrayType(baseType, 0, ErrorType.SIZE);
    }

    private ArrayType(Type baseType, int bound, ErrorType errorType) {
        this.baseType = baseType;
        this.bound = bound;
        this.errorType = errorType;
    }

    @Override
    String render() {
        return this.render("");
    }

    @Override
    public String toString(Object obj) {
        Vector v = (Vector)obj;
        String img = "[";
        String sep = "";
        for (Object val : v) {
            img = val == null ? String.valueOf(img) + sep + "??" : (val instanceof BadValue ? String.valueOf(img) + sep + "##" : String.valueOf(img) + sep + this.baseType.render(val));
            sep = ", ";
        }
        return String.valueOf(img) + "]";
    }

    private String render(String bounds) {
        bounds = this.errorType == ErrorType.SIZE ? String.valueOf(bounds) + "[" + ProgramLine.bad("???") : (this.errorType == ErrorType.BRACKET ? String.valueOf(bounds) + "[" + this.bound + ProgramLine.bad("]") : String.valueOf(bounds) + "[" + this.bound + "]");
        if (this.baseType instanceof ArrayType) {
            return ((ArrayType)this.baseType).render(bounds);
        }
        return String.valueOf(this.baseType.render()) + bounds;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String bounds) {
        if (this.baseType instanceof ArrayType) {
            return ((ArrayType)this.baseType).render("[" + this.bound + "]" + bounds);
        }
        return String.valueOf(this.baseType.render()) + "[" + this.bound + "]" + bounds;
    }

    @Override
    boolean canCopy(Type type) {
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return this.bound == at.bound && this.baseType.canCopy(at.baseType);
        }
        return false;
    }

    @Override
    Object copy(Object val) {
        if (val instanceof BadValue) {
            return val;
        }
        Vector v = (Vector)val;
        Vector<Object> nv = new Vector<Object>(this.bound);
        for (Object ob : v) {
            nv.add(this.baseType.copy(ob));
        }
        return nv;
    }

    @Override
    Object initVal() {
        Vector<Object> v = new Vector<Object>(this.bound);
        int i = 0;
        while (i < this.bound) {
            v.add(this.baseType.initVal());
            ++i;
        }
        return v;
    }

    @Override
    Type operatorType(UnaryOperator op) {
        if (op == UnaryOperator.PIPE) {
            return BasicType.INTEGER;
        }
        return null;
    }

    @Override
    Object apply(UnaryOperator op, Object val) {
        if (op == UnaryOperator.PIPE) {
            return ((Vector)val).size();
        }
        return null;
    }

    @Override
    Type operatorType(BinaryOperator op, Type rhs) {
        if (op == BinaryOperator.BRACKET && rhs == BasicType.INTEGER) {
            return this.baseType;
        }
        return null;
    }

    @Override
    Object apply(BinaryOperator op, Type rhs, Object left, Object right) {
        if (op == BinaryOperator.BRACKET && rhs == BasicType.INTEGER) {
            if (left instanceof BadValue) {
                return left;
            }
            if (right instanceof BadValue) {
                return right;
            }
            Vector l = (Vector)left;
            Integer r = (Integer)right;
            if (r < 0 || r >= l.size()) {
                return new BadValue("Hib\u00e1s t\u00f6mbindex");
            }
            Object val = ((Vector)left).get((Integer)right);
            if (val == null) {
                return new EmptyValue("A t\u00f6mb " + r + ". eleme nem kapott kezd\u0151\u00e9rt\u00e9ket.");
            }
            return val;
        }
        return null;
    }

    @Override
    Object readData(StreamData strm, StreamState sst) throws StreamData.DataError {
        Vector<Object> value = new Vector<Object>();
        int i = 0;
        while (i < this.bound) {
            value.add(this.baseType.readData(strm, sst));
            ++i;
        }
        return value;
    }

    @Override
    void printData(StreamData str, StreamState sst, Object v) {
        if (v instanceof BadValue) {
            return;
        }
        Vector val = (Vector)v;
        String sep = "";
        for (Object elem : val) {
            str.append(sst, sep);
            this.baseType.printData(str, sst, elem);
            sep = " ";
        }
    }

    @Override
    boolean hasDataIO() {
        return true;
    }

    @Override
    boolean hasAccessor(UnaryOperator op) {
        return false;
    }

    @Override
    Object access(UnaryOperator op, Object oldVal, Object newVal) {
        return null;
    }

    @Override
    boolean hasAccessor(BinaryOperator op, Type rhs) {
        return op == BinaryOperator.BRACKET && rhs == BasicType.INTEGER;
    }

    @Override
    Object access(BinaryOperator op, Object oldVal, Object rhs, Object newVal) {
        Vector v = (Vector)((Vector)oldVal).clone();
        v.set((Integer)rhs, newVal);
        return v;
    }

    private static enum ErrorType {
        NONE,
        BRACKET,
        SIZE;

    }
}

