/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Indexer;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;

abstract class Accessor {
    Accessor() {
    }

    static Accessor parseAccessors(Lexer lex, Environment env, Type baseType) {
        if (lex.isKeyword("[")) {
            return Indexer.parseIndexer(lex, env, baseType);
        }
        return new Assigner(baseType);
    }

    abstract Type getType();

    abstract Object access(State var1, Object var2, Object var3);

    abstract ExprNode getTree(State var1, String var2, ExprNode var3);

    abstract String render();

    abstract String getError();

    private static class Assigner
    extends Accessor {
        private Type type;

        Assigner(Type type) {
            this.type = type;
        }

        @Override
        public Object access(State state, Object oldValue, Object newValue) {
            return this.type.copy(newValue);
        }

        @Override
        ExprNode getTree(State state, String pref, ExprNode subExpr) {
            return subExpr;
        }

        @Override
        Type getType() {
            return this.type;
        }

        @Override
        public String render() {
            return "";
        }

        public String toString() {
            return "";
        }

        @Override
        String getError() {
            return null;
        }
    }
}

