/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.gui;

import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamKind;
import hu.ppke.itk.plang.prog.StreamState;
import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class StreamDocument
extends DefaultStyledDocument {
    private StreamKind kind = StreamKind.INPUT;
    private int length = 0;
    private int start = 0;
    private static SimpleAttributeSet normal = new SimpleAttributeSet();
    private static SimpleAttributeSet current = new SimpleAttributeSet();
    private static SimpleAttributeSet hidden = new SimpleAttributeSet();

    static {
        StyleConstants.setBold(current, true);
        StyleConstants.setBackground(current, new Color(0.8f, 0.8f, 0.8f));
        StyleConstants.setForeground(hidden, Color.LIGHT_GRAY);
    }

    public static SimpleAttributeSet getNormalAttr() {
        return normal;
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setStream(StreamData stream) {
        try {
            this.remove(0, this.getLength());
            if (stream != null) {
                this.insertString(0, stream.getSection(0, stream.getLength()), null);
                this.kind = stream.getKind();
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Stream index error", e);
        }
    }

    public void setState(StreamState state) {
        if (state == null) {
            this.setCharacterAttributes(0, this.getLength(), normal, true);
            return;
        }
        this.length = state.getLastSec();
        this.start = state.getPtr() - this.length;
        this.setCharacterAttributes(0, this.start, this.kind == StreamKind.INPUT ? hidden : normal, true);
        this.setCharacterAttributes(this.start, this.length, current, true);
        this.setCharacterAttributes(this.start + this.length, this.getLength() - this.start - this.length, this.kind == StreamKind.OUTPUT ? hidden : normal, true);
    }
}

