/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.gui;

import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.StreamState;
import hu.ppke.itk.plang.prog.Type;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class StateList
extends AbstractTableModel {
    private Vector<State> states;
    private Vector<String> names;
    private Vector<Type> types;

    @Override
    public int getColumnCount() {
        if (this.names != null) {
            return this.names.size() + 1;
        }
        return 0;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "L\u00c9P\u00c9S";
        }
        if (this.names != null) {
            return this.names.elementAt(col - 1);
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.states != null) {
            return this.states.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.states != null) {
            if (columnIndex == 0) {
                return rowIndex + 1;
            }
            Object val = this.states.elementAt(rowIndex).getVar(this.names.elementAt(columnIndex - 1));
            if (val == null) {
                return "<html><font color=\"blue\">???";
            }
            if (val instanceof BadValue) {
                return "<html><font color=\"red\">###";
            }
            return this.types.get(columnIndex - 1).render(val);
        }
        return null;
    }

    void setStates(List<State> stl) {
        if (this.states != null) {
            int l = this.states.size();
            this.states = null;
            this.names = null;
            this.types = null;
            this.fireTableRowsDeleted(0, l - 1);
            this.fireTableStructureChanged();
        }
        if (stl != null) {
            this.states = new Vector<State>(stl);
            TreeSet<String> ns = new TreeSet<String>(this.states.get(0).getVarNames());
            this.names = new Vector<String>(ns);
            this.types = new Vector(this.names.size());
            for (String var : this.names) {
                this.types.add(this.states.get(0).getVarType(var));
            }
            this.fireTableRowsInserted(0, this.states.size() - 1);
            this.fireTableStructureChanged();
        }
    }

    public StreamState getStreamState(String name, int row) {
        return this.states.elementAt(row).getStreamState(name);
    }

    public State getState(int row) {
        if (row < 0 || row >= this.states.size()) {
            return null;
        }
        return this.states.elementAt(row);
    }
}

