/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.gui;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.prog.State;

public abstract class ProgramLine {
    public static final ProgramLine emptyLine = new ProgramLine(0){

        @Override
        protected String render() {
            return " ";
        }

        @Override
        public ExprNode getExpr(State state) {
            return null;
        }

        @Override
        public void setLine(int l) {
        }
    };
    private int indent;
    private String error;

    protected ProgramLine(int indent) {
        this.indent = indent;
    }

    protected ProgramLine(String error) {
        this.indent = 0;
        this.error = error;
    }

    protected ProgramLine(int indent, String error) {
        this.indent = indent;
        this.error = error;
    }

    public final int getIndent() {
        return this.indent;
    }

    protected final String indent() {
        String sp = "&nbsp;&nbsp;";
        String r = "";
        int i = 0;
        while (i < this.indent) {
            r = String.valueOf(r) + sp;
            ++i;
        }
        return r;
    }

    public static final String bad(String s) {
        return "<font color=\"red\">" + s + "</font>";
    }

    protected abstract String render();

    public abstract void setLine(int var1);

    public abstract ExprNode getExpr(State var1);

    public final String toString() {
        return this.render();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public static String unHtml(String h) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < h.length()) {
            if (h.charAt(i) == '&') {
                String ent = h.substring(i + 1, h.indexOf(59, i + 1));
                if (ent.equals("lt")) {
                    s.append('<');
                } else if (ent.equals("gt")) {
                    s.append('>');
                } else if (ent.equals("nbsp")) {
                    s.append(' ');
                } else if (ent.equals("amp")) {
                    s.append('&');
                } else {
                    s.append('?');
                }
                i += ent.length() + 1;
            } else if (h.charAt(i) == '<') {
                i = h.indexOf(62, i);
            } else {
                s.append(h.charAt(i));
            }
            ++i;
        }
        return s.toString();
    }
}

