/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.gui;

import hu.ppke.itk.plang.gui.ProgramLine;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;

public class ProgLineRenderer
extends DefaultListCellRenderer {
    private final Font textFont;

    public ProgLineRenderer(Font font) {
        this.textFont = font;
    }

    private String render(ProgramLine line) {
        if (line.getError() != null) {
            return "<html><body bgcolor=\"#ffe0e0\">" + line.render() + "</html>";
        }
        return "<html>" + line.render() + "</html>";
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value instanceof ProgramLine) {
            ProgramLine line = (ProgramLine)value;
            JComponent lc = (JComponent)super.getListCellRendererComponent((JList<?>)list, this.render(line), index, isSelected, hasFocus);
            lc.setFont(this.textFont);
            if (line.hasError()) {
                lc.setToolTipText("HIBA: " + line.getError());
            } else {
                lc.setToolTipText(null);
            }
            return lc;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
    }
}

