/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.gui;

import hu.ppke.itk.plang.gui.CallStack;
import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ExprRenderer;
import hu.ppke.itk.plang.gui.ExprTree;
import hu.ppke.itk.plang.gui.PrefDialog;
import hu.ppke.itk.plang.gui.ProgLineRenderer;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.gui.ProgramList;
import hu.ppke.itk.plang.gui.StateList;
import hu.ppke.itk.plang.gui.StreamDocument;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.MainProgram;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.StreamData;
import hu.ppke.itk.plang.prog.StreamKind;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private Icon loadIcon;
    private Icon runIcon;
    private Icon stopIcon;
    private Icon parseIcon;
    private Icon copyIcon;
    private Icon editIcon;
    private Icon saveIcon;
    private Icon prefIcon;
    private JFileChooser fileChooser;
    private Action loadAction;
    private Action saveAction;
    private Action parseAction;
    private Action editAction;
    private Action copyAction;
    private Action runAction;
    private Action stopAction;
    private Action enterAction;
    private Action leaveAction;
    private PrefDialog prefDialog;
    private Action showPreferences;
    private ListSelectionListener selProgLine;
    private ListSelectionListener selProgState;
    private TreeSelectionListener selExprNode;
    private JList progList;
    private JTextArea progText;
    private boolean progTextChanged;
    private static final String PROGLIST = "ProgList";
    private static final String PROGTEXT = "ProgText";
    private JPanel progPanel;
    private JList callStack;
    private JTable stateTable;
    private JTree exprTree;
    private JTabbedPane inpPanes;
    private JTabbedPane outPanes;
    private Font textFont;

    private void editState() {
        this.loadAction.setEnabled(true);
        this.saveAction.setEnabled(true);
        this.parseAction.setEnabled(true);
        this.editAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.runAction.setEnabled(false);
        ((CardLayout)this.progPanel.getLayout()).show(this.progPanel, PROGTEXT);
    }

    private void listState() {
        this.loadAction.setEnabled(false);
        this.saveAction.setEnabled(false);
        this.parseAction.setEnabled(false);
        this.editAction.setEnabled(true);
        ((CardLayout)this.progPanel.getLayout()).show(this.progPanel, PROGLIST);
    }

    private void runState() {
        this.editAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.runAction.setEnabled(false);
        this.stopAction.setEnabled(true);
        int i = 0;
        while (i < this.inpPanes.getComponentCount()) {
            ((JTextPane)((JScrollPane)this.inpPanes.getComponentAt(i)).getViewport().getView()).setEditable(false);
            ++i;
        }
    }

    private void stopState() {
        this.editAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.runAction.setEnabled(true);
        this.stopAction.setEnabled(false);
        this.enterAction.setEnabled(false);
        this.leaveAction.setEnabled(false);
        int i = 0;
        while (i < this.inpPanes.getComponentCount()) {
            JTextPane p = (JTextPane)((JScrollPane)this.inpPanes.getComponentAt(i)).getViewport().getView();
            p.setEditable(true);
            p.setCharacterAttributes(StreamDocument.getNormalAttr(), true);
            ++i;
        }
    }

    private static StreamDocument getDocument(JTabbedPane panes, int ind) {
        return (StreamDocument)((JTextPane)((JScrollPane)panes.getComponentAt(ind)).getViewport().getView()).getDocument();
    }

    private void updatePanes(JTabbedPane panes, Set<String> streams, boolean edit) {
        int ind = 0;
        Iterator<String> files = streams.iterator();
        String f = files.hasNext() ? files.next() : null;
        String t = ind < panes.getComponentCount() ? panes.getTitleAt(ind) : null;
        while (f != null || t != null) {
            if (f == null || t != null && t.compareTo(f) < 0) {
                panes.remove(ind);
                t = ind < panes.getComponentCount() ? panes.getTitleAt(ind) : null;
                continue;
            }
            if (t == null || f != null && f.compareTo(t) < 0) {
                JTextPane text = new JTextPane(new StreamDocument());
                text.setFont(this.textFont);
                text.setCharacterAttributes(StreamDocument.getNormalAttr(), true);
                text.setEditable(edit);
                panes.insertTab(f, null, new JScrollPane(text), null, ind);
                ++ind;
                f = files.hasNext() ? files.next() : null;
                continue;
            }
            t = ++ind < panes.getComponentCount() ? panes.getTitleAt(ind) : null;
            String string = f = files.hasNext() ? files.next() : null;
        }
    }

    private static void setStreamStates(JTabbedPane panes, State state) {
        int i = 0;
        while (i < panes.getComponentCount()) {
            MainFrame.getDocument(panes, i).setState(state == null ? null : state.getStreamState(panes.getTitleAt(i)));
            ++i;
        }
    }

    private void updateFont() {
        this.progList.setCellRenderer(new ProgLineRenderer(this.textFont));
        this.stateTable.setFont(this.textFont);
        this.stateTable.setRowHeight(this.stateTable.getGraphics().getFontMetrics(this.textFont).getHeight());
        this.stateTable.getTableHeader().setFont(this.textFont);
        this.stateTable.getParent().setFont(this.textFont);
        this.progText.setFont(this.textFont);
        this.exprTree.setCellRenderer(new ExprRenderer(this.textFont));
        int i = 0;
        while (i < this.inpPanes.getComponentCount()) {
            ((JScrollPane)this.inpPanes.getComponentAt(i)).getViewport().getView().setFont(this.textFont);
            ++i;
        }
        i = 0;
        while (i < this.outPanes.getComponentCount()) {
            ((JScrollPane)this.outPanes.getComponentAt(i)).getViewport().getView().setFont(this.textFont);
            ++i;
        }
    }

    public MainFrame() {
        super("PLanG");
        ClassLoader cl = this.getClass().getClassLoader();
        this.loadIcon = new ImageIcon(cl.getResource("images/load.png"));
        this.runIcon = new ImageIcon(cl.getResource("images/run.png"));
        this.stopIcon = new ImageIcon(cl.getResource("images/stop.png"));
        this.parseIcon = new ImageIcon(cl.getResource("images/parse.png"));
        this.copyIcon = new ImageIcon(cl.getResource("images/copy.png"));
        this.editIcon = new ImageIcon(cl.getResource("images/edit.png"));
        this.saveIcon = new ImageIcon(cl.getResource("images/save.png"));
        this.prefIcon = new ImageIcon(cl.getResource("images/pref.png"));
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter(new PlangFilter());
        this.loadAction = new AbstractAction("Bet\u00f6lt", this.loadIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (MainFrame.this.progTextChanged && JOptionPane.showConfirmDialog(MainFrame.this, "A programsz\u00f6veg v\u00e1ltoz\u00e1sai nincsenek elmentve. Biztosan be akarsz t\u00f6lteni egy \u00faj f\u00e1jlt?", "Bet\u00f6lt\u00e9s", 0, 2) != 0) {
                    return;
                }
                try {
                    if (MainFrame.this.fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(MainFrame.this.fileChooser.getSelectedFile()), "ISO-8859-2"));
                        MainFrame.this.progText.setText("");
                        String line = rd.readLine();
                        while (line != null) {
                            MainFrame.this.progText.append(String.valueOf(line) + "\n");
                            line = rd.readLine();
                        }
                        rd.close();
                        MainFrame.this.progTextChanged = false;
                    }
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Nem siker\u00fclt az olvas\u00e1s a k\u00f6vetkez\u00f6 f\u00e1jlb\u00f3l: " + e.getMessage(), "Hiba a megnyit\u00e1s sor\u00e1n", 0);
                    System.err.println(e.getMessage());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Nem siker\u00fclt az olvas\u00e1s a k\u00f6vetkez\u0151 f\u00e1jlb\u00f3l: " + e.getMessage(), "Hiba az olvas\u00e1s sor\u00e1n", 0);
                    System.err.println(e.getMessage());
                }
            }
        };
        this.saveAction = new AbstractAction("Ment", this.saveIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    if (!(MainFrame.this.fileChooser.showSaveDialog(MainFrame.this) != 0 || MainFrame.this.fileChooser.getSelectedFile().exists() && JOptionPane.showConfirmDialog(MainFrame.this, "A f\u00e1jl l\u00e9tezik, fel\u00fcl\u00edrjam?", "L\u00e9tez\u0151 f\u00e1jl", 0, 3) != 0)) {
                        PrintWriter wr = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(MainFrame.this.fileChooser.getSelectedFile()), "ISO-8859-2"));
                        wr.print(MainFrame.this.progText.getText());
                        wr.close();
                        MainFrame.this.progTextChanged = false;
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Nem siker\u00fclt a ment\u00e9s a k\u00f6vetkez\u0151 f\u00e1jlba: " + e.getMessage(), "Hiba a ment\u00e9s sor\u00e1n", 0);
                    System.err.println(e.getMessage());
                }
            }
        };
        this.parseAction = new AbstractAction("\u00c9rtelmez", this.parseIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    MainProgram prog = MainProgram.parseMainProgram(new Lexer(new StringReader(MainFrame.this.progText.getText())));
                    ((ProgramList)MainFrame.this.progList.getModel()).setProgram(prog);
                    MainFrame.this.listState();
                    boolean ok = !prog.hasError();
                    MainFrame.this.runAction.setEnabled(ok);
                    MainFrame.this.copyAction.setEnabled(ok);
                    if (ok) {
                        MainFrame.this.updatePanes(MainFrame.this.inpPanes, prog.getStreams(StreamKind.INPUT), true);
                        MainFrame.this.updatePanes(MainFrame.this.outPanes, prog.getStreams(StreamKind.OUTPUT), false);
                    }
                }
                catch (Throwable t) {
                    if ("off".equals(System.getProperty("hu.ppke.itk.plang.errorDlg"))) {
                        throw new RuntimeException(t);
                    }
                    JOptionPane.showMessageDialog(MainFrame.this, "Bels\u0151 hiba t\u00f6rt\u00e9nt a sz\u00f6veg \u00e9rtelmez\u00e9se k\u00f6zben.", "HIBA", 0);
                }
            }
        };
        this.editAction = new AbstractAction("Szerkeszt", this.editIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainFrame.this.editState();
            }
        };
        this.copyAction = new AbstractAction("M\u00e1sol", this.copyIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainFrame.this.progText.setText("");
                ProgramList lst = (ProgramList)MainFrame.this.progList.getModel();
                int i = 0;
                while (i < lst.getSize()) {
                    MainFrame.this.progText.append(String.valueOf(ProgramLine.unHtml(lst.getElementAt(i).toString())) + "\n");
                    ++i;
                }
                MainFrame.this.editState();
            }
        };
        this.runAction = new AbstractAction("Start", this.runIcon){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainProgram prog = ((ProgramList)MainFrame.this.progList.getModel()).getProgram();
                if (prog != null && !prog.hasError()) {
                    HashMap<String, String> input = new HashMap<String, String>();
                    int i = 0;
                    while (i < MainFrame.this.inpPanes.getComponentCount()) {
                        input.put(MainFrame.this.inpPanes.getTitleAt(i), MainFrame.getDocument(MainFrame.this.inpPanes, i).getText());
                        ++i;
                    }
                    CallStack cs = (CallStack)MainFrame.this.callStack.getModel();
                    try {
                        TreeMap<String, StreamData> output = new TreeMap<String, StreamData>();
                        State last = cs.runProgram(prog, input, output);
                        int i2 = 0;
                        while (i2 < MainFrame.this.outPanes.getComponentCount()) {
                            MainFrame.getDocument(MainFrame.this.outPanes, i2).setStream((StreamData)output.get(MainFrame.this.outPanes.getTitleAt(i2)));
                            ++i2;
                        }
                        MainFrame.this.runState();
                        MainFrame.this.stateTable.setRowSelectionInterval(MainFrame.this.stateTable.getRowCount() - 1, MainFrame.this.stateTable.getRowCount() - 1);
                        MainFrame.this.stateTable.scrollRectToVisible(MainFrame.this.stateTable.getCellRect(MainFrame.this.stateTable.getSelectedRow(), MainFrame.this.stateTable.getSelectedColumn(), true));
                        if (last.getError() != null) {
                            JOptionPane.showMessageDialog(MainFrame.this, "A program fut\u00e1sa a k\u00f6vetkez\u0151 hiba miatt megszakadt:\n" + last.getError(), "Fut\u00e1si hiba", 2);
                        }
                    }
                    catch (OutOfMemoryError err) {
                        JOptionPane.showMessageDialog(MainFrame.this, "Elfogyott a mem\u00f3ria a program fut\u00e1s\u00e1nak szimul\u00e1ci\u00f3ja sor\u00e1n.\nPr\u00f3b\u00e1lkozz kevesebb l\u00e9p\u00e9st v\u00e9grehajtani, vagy kisebb t\u00f6mb\u00f6ket haszn\u00e1lni.", "Hiba", 0);
                    }
                    catch (Throwable t) {
                        if ("off".equals(System.getProperty("hu.ppke.itk.plang.errorDlg"))) {
                            throw new RuntimeException(t);
                        }
                        JOptionPane.showMessageDialog(MainFrame.this, "Bels\u0151 hiba t\u00f6rt\u00e9nt a program fut\u00e1s\u00e1nak szimul\u00e1ci\u00f3ja k\u00f6zben.", "HIBA", 0);
                    }
                }
            }
        };
        this.stopAction = new AbstractAction("Stop", this.stopIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallStack cs = (CallStack)MainFrame.this.callStack.getModel();
                cs.runProgram(null, null, null);
                MainFrame.setStreamStates(MainFrame.this.inpPanes, null);
                int i = 0;
                while (i < MainFrame.this.outPanes.getComponentCount()) {
                    MainFrame.getDocument(MainFrame.this.outPanes, i).setStream(null);
                    ++i;
                }
                MainFrame.this.stopState();
            }
        };
        this.enterAction = new AbstractAction("Enter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExprNode n = (ExprNode)MainFrame.this.exprTree.getSelectionPath().getLastPathComponent();
                List<State> sp = n.getSubStates();
                if (sp != null) {
                    ((CallStack)MainFrame.this.callStack.getModel()).enter(n.toString(), sp);
                }
                MainFrame.this.leaveAction.setEnabled(true);
            }
        };
        this.leaveAction = new AbstractAction("Leave"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CallStack)MainFrame.this.callStack.getModel()).leave();
                if (MainFrame.this.callStack.getModel().getSize() <= 1) {
                    MainFrame.this.leaveAction.setEnabled(false);
                }
            }
        };
        this.showPreferences = new AbstractAction("Be\u00e1ll\u00edt\u00e1sok", this.prefIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.prefDialog.showDlg()) {
                    MainFrame.this.textFont = MainFrame.this.prefDialog.getTextFont();
                    MainFrame.this.updateFont();
                    ((CallStack)MainFrame.this.callStack.getModel()).setMaxSteps(MainFrame.this.prefDialog.getStepNum());
                }
            }
        };
        this.loadAction.putValue("ShortDescription", "Bet\u00f6lt\u00e9s");
        this.saveAction.putValue("ShortDescription", "Kiment\u00e9s");
        this.parseAction.putValue("ShortDescription", "Programsz\u00f6veg \u00e9rtelmez\u00e9se");
        this.editAction.putValue("ShortDescription", "Szerkeszt\u00e9s");
        this.copyAction.putValue("ShortDescription", "\u00c9rtelmezett program szerkeszt\u00e9se");
        this.runAction.putValue("ShortDescription", "Futtat\u00e1s");
        this.stopAction.putValue("ShortDescription", "Futtat\u00e1s v\u00e9ge");
        this.stopAction.setEnabled(false);
        this.enterAction.putValue("ShortDescription", "Bel\u00e9p\u00e9s alprogramba");
        this.enterAction.setEnabled(false);
        this.leaveAction.putValue("ShortDescription", "Alprogram elhagy\u00e1sa");
        this.leaveAction.setEnabled(false);
        this.showPreferences.putValue("ShortDescription", "Be\u00e1ll\u00edt\u00e1sok");
        this.selProgLine = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    ProgramLine line = (ProgramLine)MainFrame.this.progList.getSelectedValue();
                    if (line != null) {
                        ((ExprTree)MainFrame.this.exprTree.getModel()).setRoot(line.getExpr(null));
                    } else {
                        ((ExprTree)MainFrame.this.exprTree.getModel()).setRoot(null);
                    }
                }
            }
        };
        this.selProgState = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    State state = ((StateList)MainFrame.this.stateTable.getModel()).getState(MainFrame.this.stateTable.getSelectedRow());
                    if (state == null) {
                        MainFrame.this.progList.setSelectedIndex(-1);
                        ((ExprTree)MainFrame.this.exprTree.getModel()).setRoot(ExprNode.EMPTY);
                    } else {
                        ProgramLine line = (ProgramLine)MainFrame.this.progList.getModel().getElementAt(state.getLine());
                        if (state.getError() == null) {
                            MainFrame.this.progList.setSelectedIndex(state.getLine());
                            MainFrame.this.progList.ensureIndexIsVisible(MainFrame.this.progList.getSelectedIndex());
                            ((ExprTree)MainFrame.this.exprTree.getModel()).setRoot(line.getExpr(state));
                        } else {
                            MainFrame.this.progList.setSelectedIndex(state.getLine());
                            ((ExprTree)MainFrame.this.exprTree.getModel()).setRoot(new ExprNode("<font color=\"red\">" + state.getError() + "</font>", new ExprNode[0], null));
                        }
                        MainFrame.setStreamStates(MainFrame.this.inpPanes, state);
                        MainFrame.setStreamStates(MainFrame.this.outPanes, state);
                    }
                }
            }
        };
        this.selExprNode = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath p = MainFrame.this.exprTree.getSelectionPath();
                if (p != null) {
                    ExprNode node = (ExprNode)p.getLastPathComponent();
                    MainFrame.this.enterAction.setEnabled(node.getSubStates() != null);
                } else {
                    MainFrame.this.enterAction.setEnabled(false);
                }
            }
        };
        this.progTextChanged = false;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!MainFrame.this.progTextChanged || JOptionPane.showConfirmDialog(MainFrame.this, "A programsz\u00f6veg v\u00e1ltoz\u00e1sai nincsenek elmentve. Biztosan ki akarsz l\u00e9pni?", "Kil\u00e9p\u00e9s", 0, 2) == 0) {
                    MainFrame.this.dispose();
                }
            }
        });
        this.prefDialog = new PrefDialog(this);
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.loadAction);
        toolbar.add(this.saveAction);
        toolbar.addSeparator();
        toolbar.add(this.parseAction);
        toolbar.add(this.editAction);
        toolbar.add(this.copyAction);
        toolbar.addSeparator();
        toolbar.add(this.runAction);
        toolbar.add(this.stopAction);
        if ("on".equals(System.getProperty("hu.ppke.itk.plang.subprograms"))) {
            toolbar.addSeparator();
            toolbar.add(this.enterAction);
            toolbar.add(this.leaveAction);
        }
        toolbar.addSeparator();
        toolbar.add(this.showPreferences);
        toolbar.setFloatable(false);
        this.getContentPane().add((Component)toolbar, "First");
        this.textFont = new Font("Monospaced", 0, 12);
        this.progList = new JList(new ProgramList());
        this.progList.setCellRenderer(new ProgLineRenderer(this.textFont));
        this.progList.setSelectionMode(0);
        this.progList.addListSelectionListener(this.selProgLine);
        JScrollPane progScrl = new JScrollPane(this.progList);
        this.progText = new JTextArea();
        this.progText.setFont(this.textFont);
        this.progText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                MainFrame.this.progTextChanged = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MainFrame.this.progTextChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MainFrame.this.progTextChanged = true;
            }
        });
        JScrollPane textScrl = new JScrollPane(this.progText);
        this.progPanel = new JPanel(new CardLayout());
        this.progPanel.add((Component)progScrl, PROGLIST);
        this.progPanel.add((Component)textScrl, PROGTEXT);
        this.exprTree = new JTree(new ExprTree());
        this.exprTree.setCellRenderer(new ExprRenderer(this.textFont));
        this.exprTree.setShowsRootHandles(false);
        this.exprTree.getSelectionModel().setSelectionMode(1);
        this.exprTree.getSelectionModel().addTreeSelectionListener(this.selExprNode);
        this.exprTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() >= 2) {
                    MainFrame.this.enterAction.actionPerformed(null);
                }
            }
        });
        JScrollPane exprScrl = new JScrollPane(this.exprTree);
        JSplitPane left = new JSplitPane(0, this.progPanel, exprScrl);
        this.stateTable = new JTable(new StateList());
        this.stateTable.getSelectionModel().setSelectionMode(0);
        this.stateTable.getSelectionModel().addListSelectionListener(this.selProgState);
        this.stateTable.setAutoResizeMode(0);
        this.stateTable.setFont(this.textFont);
        JScrollPane tableScrl = new JScrollPane(this.stateTable);
        this.callStack = new JList(new CallStack((StateList)this.stateTable.getModel(), this.prefDialog.getStepNum()));
        this.inpPanes = new JTabbedPane();
        this.outPanes = new JTabbedPane();
        JPanel states = new JPanel(new BorderLayout());
        if ("on".equals(System.getProperty("hu.ppke.itk.plang.subprograms"))) {
            states.add((Component)this.callStack, "North");
        }
        states.add(tableScrl);
        JSplitPane console = new JSplitPane(1, this.inpPanes, this.outPanes);
        JSplitPane right = new JSplitPane(0, states, console);
        JSplitPane all = new JSplitPane(1, left, right);
        this.getContentPane().add(all);
        this.pack();
        left.setDividerLocation(0.7);
        console.setDividerLocation(0.5);
        right.setDividerLocation(0.7);
        this.editState();
    }

    private class PlangFilter
    extends FileFilter {
        private PlangFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String n = f.getName();
            return n.substring(n.lastIndexOf(46) + 1).toLowerCase().equals("plang");
        }

        @Override
        public String getDescription() {
            return "Plang programok (*.plang)";
        }
    }
}

