/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.cli;

import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.MainProgram;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.StreamKind;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.List;

public class Interpreter {
    private String programText;

    public Interpreter(String programFile) throws IOException {
        this.programText = Interpreter.readFile(programFile).toString();
    }

    public boolean run(int maxSteps) {
        State last;
        MainProgram prog;
        block16: {
            prog = MainProgram.parseMainProgram(new Lexer(new StringReader(this.programText)));
            if (prog.hasError()) {
                for (ProgramLine line : prog.getLines()) {
                    if (!line.hasError()) continue;
                    System.err.println(">> " + ProgramLine.unHtml(line.toString()) + "\n" + line.getError() + "\n");
                }
                System.err.println("Hib\u00e1s a program!");
                return false;
            }
            HashMap<String, String> input = new HashMap<String, String>();
            for (String stream : prog.getStreams(StreamKind.INPUT)) {
                String content = null;
                if ("BEMENET".equals(stream)) {
                    try {
                        content = Interpreter.readFile(System.in).toString();
                    }
                    catch (IOException e) {
                        content = "";
                    }
                } else {
                    try {
                        content = Interpreter.readFile(stream).toString();
                    }
                    catch (IOException e) {
                        System.err.println("Beolvas\u00e1s sikertelen: " + e.getLocalizedMessage());
                        return false;
                    }
                }
                input.put(stream, content);
            }
            List<State> states = prog.runProgram(input, maxSteps);
            last = states.get(states.size() - 1);
            String error = last.getError();
            if (error == null) break block16;
            System.err.println("Fut\u00e1si idej\u0171 hiba: " + error);
            return false;
        }
        try {
            for (String stream : prog.getStreams(StreamKind.OUTPUT)) {
                String content = last.getStream(stream).getContent();
                if ("KIMENET".equals(stream)) {
                    System.out.print(content);
                    continue;
                }
                try {
                    FileWriter writer = new FileWriter(stream);
                    writer.write(content);
                    writer.close();
                }
                catch (IOException e) {
                    System.err.println("Ki\u00edr\u00e1s sikertelen: " + e.getLocalizedMessage());
                    System.exit(1);
                }
            }
        }
        catch (OutOfMemoryError err) {
            System.err.println("Elfogyott a mem\u00f3ria a futtat\u00e1s sor\u00e1n.");
            System.exit(1);
        }
        return true;
    }

    static StringBuffer readFile(String path) throws IOException {
        return Interpreter.readFile(new FileInputStream(path));
    }

    static StringBuffer readFile(InputStream input) throws IOException {
        StringBuffer str = new StringBuffer();
        CharBuffer buf = CharBuffer.allocate(1024);
        InputStreamReader reader = new InputStreamReader(input);
        while (reader.read(buf) > 0) {
            buf.flip();
            str.append(buf);
            buf.clear();
        }
        reader.close();
        return str;
    }
}

